/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.rule;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.NotificationRuleId;
import org.thingsboard.server.common.data.id.NotificationTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.rule.NotificationRuleConfig;
import org.thingsboard.server.common.data.notification.rule.NotificationRuleRecipientsConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class NotificationRule
extends BaseData<NotificationRuleId>
implements HasName,
TenantEntity,
ExportableEntity<NotificationRuleId>,
Serializable {
    private TenantId tenantId;
    @NotBlank
    @NoXss
    @Length(max=255, message="cannot be longer than 255 chars")
    private String name;
    private boolean enabled;
    @NotNull
    private NotificationTemplateId templateId;
    @NotNull
    private NotificationRuleTriggerType triggerType;
    @NotNull
    @Valid
    private NotificationRuleTriggerConfig triggerConfig;
    @NotNull
    @Valid
    private NotificationRuleRecipientsConfig recipientsConfig;
    @Valid
    private NotificationRuleConfig additionalConfig;
    private NotificationRuleId externalId;

    public NotificationRule(NotificationRule other) {
        super(other);
        this.tenantId = other.tenantId;
        this.name = other.name;
        this.enabled = other.enabled;
        this.templateId = other.templateId;
        this.triggerType = other.triggerType;
        this.triggerConfig = other.triggerConfig;
        this.recipientsConfig = other.recipientsConfig;
        this.additionalConfig = other.additionalConfig;
        this.externalId = other.externalId;
    }

    @JsonIgnore
    @AssertTrue(message="trigger type not matching")
    public @AssertTrue(message="trigger type not matching") boolean isValid() {
        return this.triggerType == this.triggerConfig.getTriggerType() && this.triggerType == this.recipientsConfig.getTriggerType();
    }

    @JsonIgnore
    public String getDeduplicationKey() {
        String targets = this.recipientsConfig.getTargetsTable().values().stream().flatMap(Collection::stream).sorted().map(Object::toString).collect(Collectors.joining(","));
        return String.join((CharSequence)":", targets, this.triggerConfig.getDeduplicationKey());
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.NOTIFICATION_RULE;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public NotificationTemplateId getTemplateId() {
        return this.templateId;
    }

    @Generated
    public NotificationRuleTriggerType getTriggerType() {
        return this.triggerType;
    }

    @Generated
    public NotificationRuleTriggerConfig getTriggerConfig() {
        return this.triggerConfig;
    }

    @Generated
    public NotificationRuleRecipientsConfig getRecipientsConfig() {
        return this.recipientsConfig;
    }

    @Generated
    public NotificationRuleConfig getAdditionalConfig() {
        return this.additionalConfig;
    }

    @Override
    @Generated
    public NotificationRuleId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setTemplateId(NotificationTemplateId templateId) {
        this.templateId = templateId;
    }

    @Generated
    public void setTriggerType(NotificationRuleTriggerType triggerType) {
        this.triggerType = triggerType;
    }

    @Generated
    public void setTriggerConfig(NotificationRuleTriggerConfig triggerConfig) {
        this.triggerConfig = triggerConfig;
    }

    @Generated
    public void setRecipientsConfig(NotificationRuleRecipientsConfig recipientsConfig) {
        this.recipientsConfig = recipientsConfig;
    }

    @Generated
    public void setAdditionalConfig(NotificationRuleConfig additionalConfig) {
        this.additionalConfig = additionalConfig;
    }

    @Override
    @Generated
    public void setExternalId(NotificationRuleId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public String toString() {
        return "NotificationRule(tenantId=" + String.valueOf(this.getTenantId()) + ", name=" + this.getName() + ", enabled=" + this.isEnabled() + ", templateId=" + String.valueOf(this.getTemplateId()) + ", triggerType=" + String.valueOf((Object)this.getTriggerType()) + ", triggerConfig=" + String.valueOf(this.getTriggerConfig()) + ", recipientsConfig=" + String.valueOf(this.getRecipientsConfig()) + ", additionalConfig=" + String.valueOf(this.getAdditionalConfig()) + ", externalId=" + String.valueOf(this.getExternalId()) + ")";
    }

    @Generated
    public NotificationRule() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationRule)) {
            return false;
        }
        NotificationRule other = (NotificationRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        NotificationTemplateId this$templateId = this.getTemplateId();
        NotificationTemplateId other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !((Object)this$templateId).equals(other$templateId)) {
            return false;
        }
        NotificationRuleTriggerType this$triggerType = this.getTriggerType();
        NotificationRuleTriggerType other$triggerType = other.getTriggerType();
        if (this$triggerType == null ? other$triggerType != null : !((Object)((Object)this$triggerType)).equals((Object)other$triggerType)) {
            return false;
        }
        NotificationRuleTriggerConfig this$triggerConfig = this.getTriggerConfig();
        NotificationRuleTriggerConfig other$triggerConfig = other.getTriggerConfig();
        if (this$triggerConfig == null ? other$triggerConfig != null : !this$triggerConfig.equals(other$triggerConfig)) {
            return false;
        }
        NotificationRuleRecipientsConfig this$recipientsConfig = this.getRecipientsConfig();
        NotificationRuleRecipientsConfig other$recipientsConfig = other.getRecipientsConfig();
        if (this$recipientsConfig == null ? other$recipientsConfig != null : !((Object)this$recipientsConfig).equals(other$recipientsConfig)) {
            return false;
        }
        NotificationRuleConfig this$additionalConfig = this.getAdditionalConfig();
        NotificationRuleConfig other$additionalConfig = other.getAdditionalConfig();
        if (this$additionalConfig == null ? other$additionalConfig != null : !((Object)this$additionalConfig).equals(other$additionalConfig)) {
            return false;
        }
        NotificationRuleId this$externalId = this.getExternalId();
        NotificationRuleId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NotificationRule;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        NotificationTemplateId $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : ((Object)$templateId).hashCode());
        NotificationRuleTriggerType $triggerType = this.getTriggerType();
        result = result * 59 + ($triggerType == null ? 43 : ((Object)((Object)$triggerType)).hashCode());
        NotificationRuleTriggerConfig $triggerConfig = this.getTriggerConfig();
        result = result * 59 + ($triggerConfig == null ? 43 : $triggerConfig.hashCode());
        NotificationRuleRecipientsConfig $recipientsConfig = this.getRecipientsConfig();
        result = result * 59 + ($recipientsConfig == null ? 43 : ((Object)$recipientsConfig).hashCode());
        NotificationRuleConfig $additionalConfig = this.getAdditionalConfig();
        result = result * 59 + ($additionalConfig == null ? 43 : ((Object)$additionalConfig).hashCode());
        NotificationRuleId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }
}

