/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.info;

import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.util.CollectionsUtil;

public class EntityActionNotificationInfo
implements RuleOriginatedNotificationInfo {
    private EntityId entityId;
    private String entityName;
    private ActionType actionType;
    private CustomerId customerId;
    private UUID userId;
    private String userTitle;
    private String userEmail;
    private String userFirstName;
    private String userLastName;

    @Override
    public Map<String, String> getTemplateData() {
        return CollectionsUtil.mapOf("entityType", this.entityId.getEntityType().getNormalName(), "entityId", this.entityId.toString(), "entityName", this.entityName, "actionType", this.actionType.name().toLowerCase(), "userId", this.userId.toString(), "userTitle", this.userTitle, "userEmail", this.userEmail, "userFirstName", this.userFirstName, "userLastName", this.userLastName);
    }

    @Override
    public CustomerId getAffectedCustomerId() {
        return this.customerId;
    }

    @Override
    public EntityId getStateEntityId() {
        return this.entityId;
    }

    @Generated
    public static EntityActionNotificationInfoBuilder builder() {
        return new EntityActionNotificationInfoBuilder();
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getEntityName() {
        return this.entityName;
    }

    @Generated
    public ActionType getActionType() {
        return this.actionType;
    }

    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public UUID getUserId() {
        return this.userId;
    }

    @Generated
    public String getUserTitle() {
        return this.userTitle;
    }

    @Generated
    public String getUserEmail() {
        return this.userEmail;
    }

    @Generated
    public String getUserFirstName() {
        return this.userFirstName;
    }

    @Generated
    public String getUserLastName() {
        return this.userLastName;
    }

    @Generated
    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    @Generated
    public void setActionType(ActionType actionType) {
        this.actionType = actionType;
    }

    @Generated
    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    @Generated
    public void setUserTitle(String userTitle) {
        this.userTitle = userTitle;
    }

    @Generated
    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    @Generated
    public void setUserFirstName(String userFirstName) {
        this.userFirstName = userFirstName;
    }

    @Generated
    public void setUserLastName(String userLastName) {
        this.userLastName = userLastName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityActionNotificationInfo)) {
            return false;
        }
        EntityActionNotificationInfo other = (EntityActionNotificationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        String this$entityName = this.getEntityName();
        String other$entityName = other.getEntityName();
        if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
            return false;
        }
        ActionType this$actionType = this.getActionType();
        ActionType other$actionType = other.getActionType();
        if (this$actionType == null ? other$actionType != null : !((Object)((Object)this$actionType)).equals((Object)other$actionType)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$userTitle = this.getUserTitle();
        String other$userTitle = other.getUserTitle();
        if (this$userTitle == null ? other$userTitle != null : !this$userTitle.equals(other$userTitle)) {
            return false;
        }
        String this$userEmail = this.getUserEmail();
        String other$userEmail = other.getUserEmail();
        if (this$userEmail == null ? other$userEmail != null : !this$userEmail.equals(other$userEmail)) {
            return false;
        }
        String this$userFirstName = this.getUserFirstName();
        String other$userFirstName = other.getUserFirstName();
        if (this$userFirstName == null ? other$userFirstName != null : !this$userFirstName.equals(other$userFirstName)) {
            return false;
        }
        String this$userLastName = this.getUserLastName();
        String other$userLastName = other.getUserLastName();
        return !(this$userLastName == null ? other$userLastName != null : !this$userLastName.equals(other$userLastName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityActionNotificationInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        String $entityName = this.getEntityName();
        result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
        ActionType $actionType = this.getActionType();
        result = result * 59 + ($actionType == null ? 43 : ((Object)((Object)$actionType)).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $userTitle = this.getUserTitle();
        result = result * 59 + ($userTitle == null ? 43 : $userTitle.hashCode());
        String $userEmail = this.getUserEmail();
        result = result * 59 + ($userEmail == null ? 43 : $userEmail.hashCode());
        String $userFirstName = this.getUserFirstName();
        result = result * 59 + ($userFirstName == null ? 43 : $userFirstName.hashCode());
        String $userLastName = this.getUserLastName();
        result = result * 59 + ($userLastName == null ? 43 : $userLastName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntityActionNotificationInfo(entityId=" + String.valueOf(this.getEntityId()) + ", entityName=" + this.getEntityName() + ", actionType=" + String.valueOf((Object)this.getActionType()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", userId=" + String.valueOf(this.getUserId()) + ", userTitle=" + this.getUserTitle() + ", userEmail=" + this.getUserEmail() + ", userFirstName=" + this.getUserFirstName() + ", userLastName=" + this.getUserLastName() + ")";
    }

    @Generated
    public EntityActionNotificationInfo() {
    }

    @ConstructorProperties(value={"entityId", "entityName", "actionType", "customerId", "userId", "userTitle", "userEmail", "userFirstName", "userLastName"})
    @Generated
    public EntityActionNotificationInfo(EntityId entityId, String entityName, ActionType actionType, CustomerId customerId, UUID userId, String userTitle, String userEmail, String userFirstName, String userLastName) {
        this.entityId = entityId;
        this.entityName = entityName;
        this.actionType = actionType;
        this.customerId = customerId;
        this.userId = userId;
        this.userTitle = userTitle;
        this.userEmail = userEmail;
        this.userFirstName = userFirstName;
        this.userLastName = userLastName;
    }

    @Generated
    public static class EntityActionNotificationInfoBuilder {
        @Generated
        private EntityId entityId;
        @Generated
        private String entityName;
        @Generated
        private ActionType actionType;
        @Generated
        private CustomerId customerId;
        @Generated
        private UUID userId;
        @Generated
        private String userTitle;
        @Generated
        private String userEmail;
        @Generated
        private String userFirstName;
        @Generated
        private String userLastName;

        @Generated
        EntityActionNotificationInfoBuilder() {
        }

        @Generated
        public EntityActionNotificationInfoBuilder entityId(EntityId entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public EntityActionNotificationInfoBuilder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        @Generated
        public EntityActionNotificationInfoBuilder actionType(ActionType actionType) {
            this.actionType = actionType;
            return this;
        }

        @Generated
        public EntityActionNotificationInfoBuilder customerId(CustomerId customerId) {
            this.customerId = customerId;
            return this;
        }

        @Generated
        public EntityActionNotificationInfoBuilder userId(UUID userId) {
            this.userId = userId;
            return this;
        }

        @Generated
        public EntityActionNotificationInfoBuilder userTitle(String userTitle) {
            this.userTitle = userTitle;
            return this;
        }

        @Generated
        public EntityActionNotificationInfoBuilder userEmail(String userEmail) {
            this.userEmail = userEmail;
            return this;
        }

        @Generated
        public EntityActionNotificationInfoBuilder userFirstName(String userFirstName) {
            this.userFirstName = userFirstName;
            return this;
        }

        @Generated
        public EntityActionNotificationInfoBuilder userLastName(String userLastName) {
            this.userLastName = userLastName;
            return this;
        }

        @Generated
        public EntityActionNotificationInfo build() {
            return new EntityActionNotificationInfo(this.entityId, this.entityName, this.actionType, this.customerId, this.userId, this.userTitle, this.userEmail, this.userFirstName, this.userLastName);
        }

        @Generated
        public String toString() {
            return "EntityActionNotificationInfo.EntityActionNotificationInfoBuilder(entityId=" + String.valueOf(this.entityId) + ", entityName=" + this.entityName + ", actionType=" + String.valueOf((Object)this.actionType) + ", customerId=" + String.valueOf(this.customerId) + ", userId=" + String.valueOf(this.userId) + ", userTitle=" + this.userTitle + ", userEmail=" + this.userEmail + ", userFirstName=" + this.userFirstName + ", userLastName=" + this.userLastName + ")";
        }
    }
}

