/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.info;

import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.util.CollectionsUtil;

public class AlarmNotificationInfo
implements RuleOriginatedNotificationInfo {
    private String alarmType;
    private String action;
    private UUID alarmId;
    private EntityId alarmOriginator;
    private String alarmOriginatorName;
    private AlarmSeverity alarmSeverity;
    private AlarmStatus alarmStatus;
    private boolean acknowledged;
    private boolean cleared;
    private CustomerId alarmCustomerId;
    private DashboardId dashboardId;

    @Override
    public Map<String, String> getTemplateData() {
        return CollectionsUtil.mapOf("alarmType", this.alarmType, "action", this.action, "alarmId", this.alarmId.toString(), "alarmSeverity", this.alarmSeverity.name().toLowerCase(), "alarmStatus", this.alarmStatus.toString(), "alarmOriginatorEntityType", this.alarmOriginator.getEntityType().getNormalName(), "alarmOriginatorName", this.alarmOriginatorName, "alarmOriginatorId", this.alarmOriginator.getId().toString());
    }

    @Override
    public CustomerId getAffectedCustomerId() {
        return this.alarmCustomerId;
    }

    @Override
    public EntityId getStateEntityId() {
        return this.alarmOriginator;
    }

    @Override
    public DashboardId getDashboardId() {
        return this.dashboardId;
    }

    @Generated
    public static AlarmNotificationInfoBuilder builder() {
        return new AlarmNotificationInfoBuilder();
    }

    @Generated
    public String getAlarmType() {
        return this.alarmType;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public UUID getAlarmId() {
        return this.alarmId;
    }

    @Generated
    public EntityId getAlarmOriginator() {
        return this.alarmOriginator;
    }

    @Generated
    public String getAlarmOriginatorName() {
        return this.alarmOriginatorName;
    }

    @Generated
    public AlarmSeverity getAlarmSeverity() {
        return this.alarmSeverity;
    }

    @Generated
    public AlarmStatus getAlarmStatus() {
        return this.alarmStatus;
    }

    @Generated
    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    @Generated
    public boolean isCleared() {
        return this.cleared;
    }

    @Generated
    public CustomerId getAlarmCustomerId() {
        return this.alarmCustomerId;
    }

    @Generated
    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public void setAlarmId(UUID alarmId) {
        this.alarmId = alarmId;
    }

    @Generated
    public void setAlarmOriginator(EntityId alarmOriginator) {
        this.alarmOriginator = alarmOriginator;
    }

    @Generated
    public void setAlarmOriginatorName(String alarmOriginatorName) {
        this.alarmOriginatorName = alarmOriginatorName;
    }

    @Generated
    public void setAlarmSeverity(AlarmSeverity alarmSeverity) {
        this.alarmSeverity = alarmSeverity;
    }

    @Generated
    public void setAlarmStatus(AlarmStatus alarmStatus) {
        this.alarmStatus = alarmStatus;
    }

    @Generated
    public void setAcknowledged(boolean acknowledged) {
        this.acknowledged = acknowledged;
    }

    @Generated
    public void setCleared(boolean cleared) {
        this.cleared = cleared;
    }

    @Generated
    public void setAlarmCustomerId(CustomerId alarmCustomerId) {
        this.alarmCustomerId = alarmCustomerId;
    }

    @Generated
    public void setDashboardId(DashboardId dashboardId) {
        this.dashboardId = dashboardId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmNotificationInfo)) {
            return false;
        }
        AlarmNotificationInfo other = (AlarmNotificationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAcknowledged() != other.isAcknowledged()) {
            return false;
        }
        if (this.isCleared() != other.isCleared()) {
            return false;
        }
        String this$alarmType = this.getAlarmType();
        String other$alarmType = other.getAlarmType();
        if (this$alarmType == null ? other$alarmType != null : !this$alarmType.equals(other$alarmType)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        UUID this$alarmId = this.getAlarmId();
        UUID other$alarmId = other.getAlarmId();
        if (this$alarmId == null ? other$alarmId != null : !((Object)this$alarmId).equals(other$alarmId)) {
            return false;
        }
        EntityId this$alarmOriginator = this.getAlarmOriginator();
        EntityId other$alarmOriginator = other.getAlarmOriginator();
        if (this$alarmOriginator == null ? other$alarmOriginator != null : !this$alarmOriginator.equals(other$alarmOriginator)) {
            return false;
        }
        String this$alarmOriginatorName = this.getAlarmOriginatorName();
        String other$alarmOriginatorName = other.getAlarmOriginatorName();
        if (this$alarmOriginatorName == null ? other$alarmOriginatorName != null : !this$alarmOriginatorName.equals(other$alarmOriginatorName)) {
            return false;
        }
        AlarmSeverity this$alarmSeverity = this.getAlarmSeverity();
        AlarmSeverity other$alarmSeverity = other.getAlarmSeverity();
        if (this$alarmSeverity == null ? other$alarmSeverity != null : !((Object)((Object)this$alarmSeverity)).equals((Object)other$alarmSeverity)) {
            return false;
        }
        AlarmStatus this$alarmStatus = this.getAlarmStatus();
        AlarmStatus other$alarmStatus = other.getAlarmStatus();
        if (this$alarmStatus == null ? other$alarmStatus != null : !((Object)((Object)this$alarmStatus)).equals((Object)other$alarmStatus)) {
            return false;
        }
        CustomerId this$alarmCustomerId = this.getAlarmCustomerId();
        CustomerId other$alarmCustomerId = other.getAlarmCustomerId();
        if (this$alarmCustomerId == null ? other$alarmCustomerId != null : !((Object)this$alarmCustomerId).equals(other$alarmCustomerId)) {
            return false;
        }
        DashboardId this$dashboardId = this.getDashboardId();
        DashboardId other$dashboardId = other.getDashboardId();
        return !(this$dashboardId == null ? other$dashboardId != null : !((Object)this$dashboardId).equals(other$dashboardId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlarmNotificationInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAcknowledged() ? 79 : 97);
        result = result * 59 + (this.isCleared() ? 79 : 97);
        String $alarmType = this.getAlarmType();
        result = result * 59 + ($alarmType == null ? 43 : $alarmType.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        UUID $alarmId = this.getAlarmId();
        result = result * 59 + ($alarmId == null ? 43 : ((Object)$alarmId).hashCode());
        EntityId $alarmOriginator = this.getAlarmOriginator();
        result = result * 59 + ($alarmOriginator == null ? 43 : $alarmOriginator.hashCode());
        String $alarmOriginatorName = this.getAlarmOriginatorName();
        result = result * 59 + ($alarmOriginatorName == null ? 43 : $alarmOriginatorName.hashCode());
        AlarmSeverity $alarmSeverity = this.getAlarmSeverity();
        result = result * 59 + ($alarmSeverity == null ? 43 : ((Object)((Object)$alarmSeverity)).hashCode());
        AlarmStatus $alarmStatus = this.getAlarmStatus();
        result = result * 59 + ($alarmStatus == null ? 43 : ((Object)((Object)$alarmStatus)).hashCode());
        CustomerId $alarmCustomerId = this.getAlarmCustomerId();
        result = result * 59 + ($alarmCustomerId == null ? 43 : ((Object)$alarmCustomerId).hashCode());
        DashboardId $dashboardId = this.getDashboardId();
        result = result * 59 + ($dashboardId == null ? 43 : ((Object)$dashboardId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AlarmNotificationInfo(alarmType=" + this.getAlarmType() + ", action=" + this.getAction() + ", alarmId=" + String.valueOf(this.getAlarmId()) + ", alarmOriginator=" + String.valueOf(this.getAlarmOriginator()) + ", alarmOriginatorName=" + this.getAlarmOriginatorName() + ", alarmSeverity=" + String.valueOf((Object)this.getAlarmSeverity()) + ", alarmStatus=" + String.valueOf((Object)this.getAlarmStatus()) + ", acknowledged=" + this.isAcknowledged() + ", cleared=" + this.isCleared() + ", alarmCustomerId=" + String.valueOf(this.getAlarmCustomerId()) + ", dashboardId=" + String.valueOf(this.getDashboardId()) + ")";
    }

    @Generated
    public AlarmNotificationInfo() {
    }

    @ConstructorProperties(value={"alarmType", "action", "alarmId", "alarmOriginator", "alarmOriginatorName", "alarmSeverity", "alarmStatus", "acknowledged", "cleared", "alarmCustomerId", "dashboardId"})
    @Generated
    public AlarmNotificationInfo(String alarmType, String action, UUID alarmId, EntityId alarmOriginator, String alarmOriginatorName, AlarmSeverity alarmSeverity, AlarmStatus alarmStatus, boolean acknowledged, boolean cleared, CustomerId alarmCustomerId, DashboardId dashboardId) {
        this.alarmType = alarmType;
        this.action = action;
        this.alarmId = alarmId;
        this.alarmOriginator = alarmOriginator;
        this.alarmOriginatorName = alarmOriginatorName;
        this.alarmSeverity = alarmSeverity;
        this.alarmStatus = alarmStatus;
        this.acknowledged = acknowledged;
        this.cleared = cleared;
        this.alarmCustomerId = alarmCustomerId;
        this.dashboardId = dashboardId;
    }

    @Generated
    public static class AlarmNotificationInfoBuilder {
        @Generated
        private String alarmType;
        @Generated
        private String action;
        @Generated
        private UUID alarmId;
        @Generated
        private EntityId alarmOriginator;
        @Generated
        private String alarmOriginatorName;
        @Generated
        private AlarmSeverity alarmSeverity;
        @Generated
        private AlarmStatus alarmStatus;
        @Generated
        private boolean acknowledged;
        @Generated
        private boolean cleared;
        @Generated
        private CustomerId alarmCustomerId;
        @Generated
        private DashboardId dashboardId;

        @Generated
        AlarmNotificationInfoBuilder() {
        }

        @Generated
        public AlarmNotificationInfoBuilder alarmType(String alarmType) {
            this.alarmType = alarmType;
            return this;
        }

        @Generated
        public AlarmNotificationInfoBuilder action(String action) {
            this.action = action;
            return this;
        }

        @Generated
        public AlarmNotificationInfoBuilder alarmId(UUID alarmId) {
            this.alarmId = alarmId;
            return this;
        }

        @Generated
        public AlarmNotificationInfoBuilder alarmOriginator(EntityId alarmOriginator) {
            this.alarmOriginator = alarmOriginator;
            return this;
        }

        @Generated
        public AlarmNotificationInfoBuilder alarmOriginatorName(String alarmOriginatorName) {
            this.alarmOriginatorName = alarmOriginatorName;
            return this;
        }

        @Generated
        public AlarmNotificationInfoBuilder alarmSeverity(AlarmSeverity alarmSeverity) {
            this.alarmSeverity = alarmSeverity;
            return this;
        }

        @Generated
        public AlarmNotificationInfoBuilder alarmStatus(AlarmStatus alarmStatus) {
            this.alarmStatus = alarmStatus;
            return this;
        }

        @Generated
        public AlarmNotificationInfoBuilder acknowledged(boolean acknowledged) {
            this.acknowledged = acknowledged;
            return this;
        }

        @Generated
        public AlarmNotificationInfoBuilder cleared(boolean cleared) {
            this.cleared = cleared;
            return this;
        }

        @Generated
        public AlarmNotificationInfoBuilder alarmCustomerId(CustomerId alarmCustomerId) {
            this.alarmCustomerId = alarmCustomerId;
            return this;
        }

        @Generated
        public AlarmNotificationInfoBuilder dashboardId(DashboardId dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        @Generated
        public AlarmNotificationInfo build() {
            return new AlarmNotificationInfo(this.alarmType, this.action, this.alarmId, this.alarmOriginator, this.alarmOriginatorName, this.alarmSeverity, this.alarmStatus, this.acknowledged, this.cleared, this.alarmCustomerId, this.dashboardId);
        }

        @Generated
        public String toString() {
            return "AlarmNotificationInfo.AlarmNotificationInfoBuilder(alarmType=" + this.alarmType + ", action=" + this.action + ", alarmId=" + String.valueOf(this.alarmId) + ", alarmOriginator=" + String.valueOf(this.alarmOriginator) + ", alarmOriginatorName=" + this.alarmOriginatorName + ", alarmSeverity=" + String.valueOf((Object)this.alarmSeverity) + ", alarmStatus=" + String.valueOf((Object)this.alarmStatus) + ", acknowledged=" + this.acknowledged + ", cleared=" + this.cleared + ", alarmCustomerId=" + String.valueOf(this.alarmCustomerId) + ", dashboardId=" + String.valueOf(this.dashboardId) + ")";
        }
    }
}

