/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.thingsboard.server.common.data.notification.AlreadySentException;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.targets.NotificationRecipient;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NotificationRequestStats {
    private final ConcurrentMap<NotificationDeliveryMethod, AtomicInteger> sent;
    private final ConcurrentMap<NotificationDeliveryMethod, Map<String, String>> errors;
    private final AtomicInteger totalErrors;
    private String error;
    @JsonIgnore
    private final ConcurrentMap<NotificationDeliveryMethod, Set<Object>> processedRecipients;

    public NotificationRequestStats() {
        this.sent = new ConcurrentHashMap<NotificationDeliveryMethod, AtomicInteger>();
        this.errors = new ConcurrentHashMap<NotificationDeliveryMethod, Map<String, String>>();
        this.totalErrors = new AtomicInteger();
        this.processedRecipients = new ConcurrentHashMap<NotificationDeliveryMethod, Set<Object>>();
    }

    @JsonCreator
    public NotificationRequestStats(@JsonProperty(value="sent") Map<NotificationDeliveryMethod, AtomicInteger> sent, @JsonProperty(value="errors") Map<NotificationDeliveryMethod, Map<String, String>> errors, @JsonProperty(value="totalErrors") Integer totalErrors, @JsonProperty(value="error") String error) {
        this.sent = new ConcurrentHashMap<NotificationDeliveryMethod, AtomicInteger>(sent);
        this.errors = new ConcurrentHashMap<NotificationDeliveryMethod, Map<String, String>>(errors);
        if (totalErrors == null) {
            totalErrors = errors != null ? Integer.valueOf(errors.values().stream().mapToInt(Map::size).sum()) : Integer.valueOf(0);
        }
        this.totalErrors = new AtomicInteger(totalErrors);
        this.error = error;
        this.processedRecipients = new ConcurrentHashMap<NotificationDeliveryMethod, Set<Object>>();
    }

    public void reportSent(NotificationDeliveryMethod deliveryMethod, NotificationRecipient recipient) {
        this.sent.computeIfAbsent(deliveryMethod, k -> new AtomicInteger()).incrementAndGet();
    }

    public void reportError(NotificationDeliveryMethod deliveryMethod, Throwable error, NotificationRecipient recipient) {
        this.reportError(deliveryMethod, error, recipient.getTitle());
    }

    public void reportError(NotificationDeliveryMethod deliveryMethod, Throwable error, String recipientTitle) {
        Map errors;
        if (error instanceof AlreadySentException) {
            return;
        }
        String errorMessage = error.getMessage();
        if (errorMessage == null) {
            errorMessage = error.getClass().getSimpleName();
        }
        if ((errors = this.errors.computeIfAbsent(deliveryMethod, k -> new ConcurrentHashMap())).size() < 100) {
            errors.put(recipientTitle, errorMessage);
        }
        this.totalErrors.incrementAndGet();
    }

    public void reportGeneralError(Throwable error) {
        this.sent.keySet().forEach(deliveryMethod -> this.reportError((NotificationDeliveryMethod)((Object)deliveryMethod), error, "General"));
        this.error = error.getMessage();
    }

    public void reportProcessed(NotificationDeliveryMethod deliveryMethod, Object recipientId) {
        this.processedRecipients.computeIfAbsent(deliveryMethod, k -> ConcurrentHashMap.newKeySet()).add(recipientId);
    }

    public boolean contains(NotificationDeliveryMethod deliveryMethod, Object recipientId) {
        Set processedRecipients = (Set)this.processedRecipients.get((Object)deliveryMethod);
        return processedRecipients != null && processedRecipients.contains(recipientId);
    }

    public int getTotalSent() {
        return this.sent.values().stream().mapToInt(AtomicInteger::get).sum();
    }

    @Generated
    public ConcurrentMap<NotificationDeliveryMethod, AtomicInteger> getSent() {
        return this.sent;
    }

    @Generated
    public ConcurrentMap<NotificationDeliveryMethod, Map<String, String>> getErrors() {
        return this.errors;
    }

    @Generated
    public AtomicInteger getTotalErrors() {
        return this.totalErrors;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public ConcurrentMap<NotificationDeliveryMethod, Set<Object>> getProcessedRecipients() {
        return this.processedRecipients;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationRequestStats)) {
            return false;
        }
        NotificationRequestStats other = (NotificationRequestStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConcurrentMap<NotificationDeliveryMethod, AtomicInteger> this$sent = this.getSent();
        ConcurrentMap<NotificationDeliveryMethod, AtomicInteger> other$sent = other.getSent();
        if (this$sent == null ? other$sent != null : !this$sent.equals(other$sent)) {
            return false;
        }
        ConcurrentMap<NotificationDeliveryMethod, Map<String, String>> this$errors = this.getErrors();
        ConcurrentMap<NotificationDeliveryMethod, Map<String, String>> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !this$errors.equals(other$errors)) {
            return false;
        }
        AtomicInteger this$totalErrors = this.getTotalErrors();
        AtomicInteger other$totalErrors = other.getTotalErrors();
        if (this$totalErrors == null ? other$totalErrors != null : !this$totalErrors.equals(other$totalErrors)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        ConcurrentMap<NotificationDeliveryMethod, Set<Object>> this$processedRecipients = this.getProcessedRecipients();
        ConcurrentMap<NotificationDeliveryMethod, Set<Object>> other$processedRecipients = other.getProcessedRecipients();
        return !(this$processedRecipients == null ? other$processedRecipients != null : !this$processedRecipients.equals(other$processedRecipients));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NotificationRequestStats;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConcurrentMap<NotificationDeliveryMethod, AtomicInteger> $sent = this.getSent();
        result = result * 59 + ($sent == null ? 43 : $sent.hashCode());
        ConcurrentMap<NotificationDeliveryMethod, Map<String, String>> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : $errors.hashCode());
        AtomicInteger $totalErrors = this.getTotalErrors();
        result = result * 59 + ($totalErrors == null ? 43 : $totalErrors.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        ConcurrentMap<NotificationDeliveryMethod, Set<Object>> $processedRecipients = this.getProcessedRecipients();
        result = result * 59 + ($processedRecipients == null ? 43 : $processedRecipients.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NotificationRequestStats(sent=" + String.valueOf(this.getSent()) + ", errors=" + String.valueOf(this.getErrors()) + ", totalErrors=" + String.valueOf(this.getTotalErrors()) + ", error=" + this.getError() + ", processedRecipients=" + String.valueOf(this.getProcessedRecipients()) + ")";
    }
}

