/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.mobile.qrCodeSettings;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.MobileAppBundleId;
import org.thingsboard.server.common.data.id.QrCodeSettingsId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.mobile.qrCodeSettings.QRCodeConfig;

@Schema
public class QrCodeSettings
extends BaseData<QrCodeSettingsId>
implements HasTenantId {
    private static final long serialVersionUID = 2628323657987010348L;
    @Schema(description="JSON object with Tenant Id.", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @Schema(description="Use settings from system level", example="true")
    private boolean useSystemSettings;
    @Schema(description="Type of application: true means use default Thingsboard app", example="true")
    private boolean useDefaultApp;
    @Schema(description="Mobile app bundle.")
    private MobileAppBundleId mobileAppBundleId;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="QR code config configuration.")
    @Valid
    @NotNull
    private QRCodeConfig qrCodeConfig;
    @Schema(description="Indicates if google play link is available", example="true")
    private boolean androidEnabled;
    @Schema(description="Indicates if apple store link is available", example="true")
    private boolean iosEnabled;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private String googlePlayLink;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private String appStoreLink;

    public QrCodeSettings() {
    }

    public QrCodeSettings(QrCodeSettingsId id) {
        super(id);
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public boolean isUseSystemSettings() {
        return this.useSystemSettings;
    }

    @Generated
    public boolean isUseDefaultApp() {
        return this.useDefaultApp;
    }

    @Generated
    public MobileAppBundleId getMobileAppBundleId() {
        return this.mobileAppBundleId;
    }

    @Generated
    public QRCodeConfig getQrCodeConfig() {
        return this.qrCodeConfig;
    }

    @Generated
    public boolean isAndroidEnabled() {
        return this.androidEnabled;
    }

    @Generated
    public boolean isIosEnabled() {
        return this.iosEnabled;
    }

    @Generated
    public String getGooglePlayLink() {
        return this.googlePlayLink;
    }

    @Generated
    public String getAppStoreLink() {
        return this.appStoreLink;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setUseSystemSettings(boolean useSystemSettings) {
        this.useSystemSettings = useSystemSettings;
    }

    @Generated
    public void setUseDefaultApp(boolean useDefaultApp) {
        this.useDefaultApp = useDefaultApp;
    }

    @Generated
    public void setMobileAppBundleId(MobileAppBundleId mobileAppBundleId) {
        this.mobileAppBundleId = mobileAppBundleId;
    }

    @Generated
    public void setQrCodeConfig(QRCodeConfig qrCodeConfig) {
        this.qrCodeConfig = qrCodeConfig;
    }

    @Generated
    public void setAndroidEnabled(boolean androidEnabled) {
        this.androidEnabled = androidEnabled;
    }

    @Generated
    public void setIosEnabled(boolean iosEnabled) {
        this.iosEnabled = iosEnabled;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Generated
    public void setGooglePlayLink(String googlePlayLink) {
        this.googlePlayLink = googlePlayLink;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Generated
    public void setAppStoreLink(String appStoreLink) {
        this.appStoreLink = appStoreLink;
    }

    @Override
    @Generated
    public String toString() {
        return "QrCodeSettings(tenantId=" + String.valueOf(this.getTenantId()) + ", useSystemSettings=" + this.isUseSystemSettings() + ", useDefaultApp=" + this.isUseDefaultApp() + ", mobileAppBundleId=" + String.valueOf(this.getMobileAppBundleId()) + ", qrCodeConfig=" + String.valueOf(this.getQrCodeConfig()) + ", androidEnabled=" + this.isAndroidEnabled() + ", iosEnabled=" + this.isIosEnabled() + ", googlePlayLink=" + this.getGooglePlayLink() + ", appStoreLink=" + this.getAppStoreLink() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QrCodeSettings)) {
            return false;
        }
        QrCodeSettings other = (QrCodeSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isUseSystemSettings() != other.isUseSystemSettings()) {
            return false;
        }
        if (this.isUseDefaultApp() != other.isUseDefaultApp()) {
            return false;
        }
        if (this.isAndroidEnabled() != other.isAndroidEnabled()) {
            return false;
        }
        if (this.isIosEnabled() != other.isIosEnabled()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        MobileAppBundleId this$mobileAppBundleId = this.getMobileAppBundleId();
        MobileAppBundleId other$mobileAppBundleId = other.getMobileAppBundleId();
        if (this$mobileAppBundleId == null ? other$mobileAppBundleId != null : !((Object)this$mobileAppBundleId).equals(other$mobileAppBundleId)) {
            return false;
        }
        QRCodeConfig this$qrCodeConfig = this.getQrCodeConfig();
        QRCodeConfig other$qrCodeConfig = other.getQrCodeConfig();
        if (this$qrCodeConfig == null ? other$qrCodeConfig != null : !((Object)this$qrCodeConfig).equals(other$qrCodeConfig)) {
            return false;
        }
        String this$googlePlayLink = this.getGooglePlayLink();
        String other$googlePlayLink = other.getGooglePlayLink();
        if (this$googlePlayLink == null ? other$googlePlayLink != null : !this$googlePlayLink.equals(other$googlePlayLink)) {
            return false;
        }
        String this$appStoreLink = this.getAppStoreLink();
        String other$appStoreLink = other.getAppStoreLink();
        return !(this$appStoreLink == null ? other$appStoreLink != null : !this$appStoreLink.equals(other$appStoreLink));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QrCodeSettings;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isUseSystemSettings() ? 79 : 97);
        result = result * 59 + (this.isUseDefaultApp() ? 79 : 97);
        result = result * 59 + (this.isAndroidEnabled() ? 79 : 97);
        result = result * 59 + (this.isIosEnabled() ? 79 : 97);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        MobileAppBundleId $mobileAppBundleId = this.getMobileAppBundleId();
        result = result * 59 + ($mobileAppBundleId == null ? 43 : ((Object)$mobileAppBundleId).hashCode());
        QRCodeConfig $qrCodeConfig = this.getQrCodeConfig();
        result = result * 59 + ($qrCodeConfig == null ? 43 : ((Object)$qrCodeConfig).hashCode());
        String $googlePlayLink = this.getGooglePlayLink();
        result = result * 59 + ($googlePlayLink == null ? 43 : $googlePlayLink.hashCode());
        String $appStoreLink = this.getAppStoreLink();
        result = result * 59 + ($appStoreLink == null ? 43 : $appStoreLink.hashCode());
        return result;
    }
}

