/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.mobile.bundle;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.id.MobileAppBundleId;
import org.thingsboard.server.common.data.mobile.bundle.MobileAppBundle;
import org.thingsboard.server.common.data.oauth2.OAuth2ClientInfo;

@Schema
public class MobileAppBundleInfo
extends MobileAppBundle {
    @Schema(description="Android package name")
    private String androidPkgName;
    @Schema(description="IOS package name")
    private String iosPkgName;
    @Schema(description="List of available oauth2 clients")
    private List<OAuth2ClientInfo> oauth2ClientInfos;
    @Schema(description="Indicates if qr code is available for bundle")
    private boolean qrCodeEnabled;

    public MobileAppBundleInfo(MobileAppBundle mobileApp, String androidPkgName, String iosPkgName, boolean qrCodeEnabled) {
        super(mobileApp);
        this.androidPkgName = androidPkgName;
        this.iosPkgName = iosPkgName;
        this.qrCodeEnabled = qrCodeEnabled;
    }

    public MobileAppBundleInfo(MobileAppBundle mobileApp, String androidPkgName, String iosPkgName, boolean qrCodeEnabled, List<OAuth2ClientInfo> oauth2ClientInfos) {
        super(mobileApp);
        this.androidPkgName = androidPkgName;
        this.iosPkgName = iosPkgName;
        this.qrCodeEnabled = qrCodeEnabled;
        this.oauth2ClientInfos = oauth2ClientInfos;
    }

    public MobileAppBundleInfo(MobileAppBundle mobileApp, List<OAuth2ClientInfo> oauth2ClientInfos) {
        super(mobileApp);
        this.oauth2ClientInfos = oauth2ClientInfos;
    }

    public MobileAppBundleInfo() {
    }

    public MobileAppBundleInfo(MobileAppBundleId mobileAppBundleId) {
        super(mobileAppBundleId);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MobileAppBundleInfo)) {
            return false;
        }
        MobileAppBundleInfo other = (MobileAppBundleInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isQrCodeEnabled() != other.isQrCodeEnabled()) {
            return false;
        }
        String this$androidPkgName = this.getAndroidPkgName();
        String other$androidPkgName = other.getAndroidPkgName();
        if (this$androidPkgName == null ? other$androidPkgName != null : !this$androidPkgName.equals(other$androidPkgName)) {
            return false;
        }
        String this$iosPkgName = this.getIosPkgName();
        String other$iosPkgName = other.getIosPkgName();
        if (this$iosPkgName == null ? other$iosPkgName != null : !this$iosPkgName.equals(other$iosPkgName)) {
            return false;
        }
        List<OAuth2ClientInfo> this$oauth2ClientInfos = this.getOauth2ClientInfos();
        List<OAuth2ClientInfo> other$oauth2ClientInfos = other.getOauth2ClientInfos();
        return !(this$oauth2ClientInfos == null ? other$oauth2ClientInfos != null : !((Object)this$oauth2ClientInfos).equals(other$oauth2ClientInfos));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MobileAppBundleInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isQrCodeEnabled() ? 79 : 97);
        String $androidPkgName = this.getAndroidPkgName();
        result = result * 59 + ($androidPkgName == null ? 43 : $androidPkgName.hashCode());
        String $iosPkgName = this.getIosPkgName();
        result = result * 59 + ($iosPkgName == null ? 43 : $iosPkgName.hashCode());
        List<OAuth2ClientInfo> $oauth2ClientInfos = this.getOauth2ClientInfos();
        result = result * 59 + ($oauth2ClientInfos == null ? 43 : ((Object)$oauth2ClientInfos).hashCode());
        return result;
    }

    @Generated
    public String getAndroidPkgName() {
        return this.androidPkgName;
    }

    @Generated
    public String getIosPkgName() {
        return this.iosPkgName;
    }

    @Generated
    public List<OAuth2ClientInfo> getOauth2ClientInfos() {
        return this.oauth2ClientInfos;
    }

    @Generated
    public boolean isQrCodeEnabled() {
        return this.qrCodeEnabled;
    }

    @Generated
    public void setAndroidPkgName(String androidPkgName) {
        this.androidPkgName = androidPkgName;
    }

    @Generated
    public void setIosPkgName(String iosPkgName) {
        this.iosPkgName = iosPkgName;
    }

    @Generated
    public void setOauth2ClientInfos(List<OAuth2ClientInfo> oauth2ClientInfos) {
        this.oauth2ClientInfos = oauth2ClientInfos;
    }

    @Generated
    public void setQrCodeEnabled(boolean qrCodeEnabled) {
        this.qrCodeEnabled = qrCodeEnabled;
    }

    @Override
    @Generated
    public String toString() {
        return "MobileAppBundleInfo(androidPkgName=" + this.getAndroidPkgName() + ", iosPkgName=" + this.getIosPkgName() + ", oauth2ClientInfos=" + String.valueOf(this.getOauth2ClientInfos()) + ", qrCodeEnabled=" + this.isQrCodeEnabled() + ")";
    }
}

