/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.mobile.app;

import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.thingsboard.server.common.data.validation.Length;

public class MobileAppVersionInfo {
    @Schema(description="Minimum supported version")
    @Length(fieldName="minVersion", max=20)
    private String minVersion;
    @Schema(description="Release notes of minimum supported version")
    @Length(fieldName="minVersionReleaseNotes", max=40000)
    private String minVersionReleaseNotes;
    @Schema(description="Latest supported version")
    @Length(fieldName="latestVersion", max=20)
    private String latestVersion;
    @Schema(description="Release notes of latest supported version")
    @Length(fieldName="latestVersionReleaseNotes", max=40000)
    private String latestVersionReleaseNotes;

    public MobileAppVersionInfo(MobileAppVersionInfo mobileAppVersionInfo) {
        this.minVersion = mobileAppVersionInfo.getMinVersion();
        this.minVersionReleaseNotes = mobileAppVersionInfo.getMinVersionReleaseNotes();
        this.latestVersion = mobileAppVersionInfo.getLatestVersion();
        this.latestVersionReleaseNotes = mobileAppVersionInfo.getLatestVersionReleaseNotes();
    }

    @Generated
    public static MobileAppVersionInfoBuilder builder() {
        return new MobileAppVersionInfoBuilder();
    }

    @Generated
    public String getMinVersion() {
        return this.minVersion;
    }

    @Generated
    public String getMinVersionReleaseNotes() {
        return this.minVersionReleaseNotes;
    }

    @Generated
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Generated
    public String getLatestVersionReleaseNotes() {
        return this.latestVersionReleaseNotes;
    }

    @Generated
    public void setMinVersion(String minVersion) {
        this.minVersion = minVersion;
    }

    @Generated
    public void setMinVersionReleaseNotes(String minVersionReleaseNotes) {
        this.minVersionReleaseNotes = minVersionReleaseNotes;
    }

    @Generated
    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    @Generated
    public void setLatestVersionReleaseNotes(String latestVersionReleaseNotes) {
        this.latestVersionReleaseNotes = latestVersionReleaseNotes;
    }

    @Generated
    public String toString() {
        return "MobileAppVersionInfo(minVersion=" + this.getMinVersion() + ", minVersionReleaseNotes=" + this.getMinVersionReleaseNotes() + ", latestVersion=" + this.getLatestVersion() + ", latestVersionReleaseNotes=" + this.getLatestVersionReleaseNotes() + ")";
    }

    @Generated
    public MobileAppVersionInfo() {
    }

    @ConstructorProperties(value={"minVersion", "minVersionReleaseNotes", "latestVersion", "latestVersionReleaseNotes"})
    @Generated
    public MobileAppVersionInfo(String minVersion, String minVersionReleaseNotes, String latestVersion, String latestVersionReleaseNotes) {
        this.minVersion = minVersion;
        this.minVersionReleaseNotes = minVersionReleaseNotes;
        this.latestVersion = latestVersion;
        this.latestVersionReleaseNotes = latestVersionReleaseNotes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MobileAppVersionInfo)) {
            return false;
        }
        MobileAppVersionInfo other = (MobileAppVersionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$minVersion = this.getMinVersion();
        String other$minVersion = other.getMinVersion();
        if (this$minVersion == null ? other$minVersion != null : !this$minVersion.equals(other$minVersion)) {
            return false;
        }
        String this$minVersionReleaseNotes = this.getMinVersionReleaseNotes();
        String other$minVersionReleaseNotes = other.getMinVersionReleaseNotes();
        if (this$minVersionReleaseNotes == null ? other$minVersionReleaseNotes != null : !this$minVersionReleaseNotes.equals(other$minVersionReleaseNotes)) {
            return false;
        }
        String this$latestVersion = this.getLatestVersion();
        String other$latestVersion = other.getLatestVersion();
        if (this$latestVersion == null ? other$latestVersion != null : !this$latestVersion.equals(other$latestVersion)) {
            return false;
        }
        String this$latestVersionReleaseNotes = this.getLatestVersionReleaseNotes();
        String other$latestVersionReleaseNotes = other.getLatestVersionReleaseNotes();
        return !(this$latestVersionReleaseNotes == null ? other$latestVersionReleaseNotes != null : !this$latestVersionReleaseNotes.equals(other$latestVersionReleaseNotes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MobileAppVersionInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $minVersion = this.getMinVersion();
        result = result * 59 + ($minVersion == null ? 43 : $minVersion.hashCode());
        String $minVersionReleaseNotes = this.getMinVersionReleaseNotes();
        result = result * 59 + ($minVersionReleaseNotes == null ? 43 : $minVersionReleaseNotes.hashCode());
        String $latestVersion = this.getLatestVersion();
        result = result * 59 + ($latestVersion == null ? 43 : $latestVersion.hashCode());
        String $latestVersionReleaseNotes = this.getLatestVersionReleaseNotes();
        result = result * 59 + ($latestVersionReleaseNotes == null ? 43 : $latestVersionReleaseNotes.hashCode());
        return result;
    }

    @Generated
    public static class MobileAppVersionInfoBuilder {
        @Generated
        private String minVersion;
        @Generated
        private String minVersionReleaseNotes;
        @Generated
        private String latestVersion;
        @Generated
        private String latestVersionReleaseNotes;

        @Generated
        MobileAppVersionInfoBuilder() {
        }

        @Generated
        public MobileAppVersionInfoBuilder minVersion(String minVersion) {
            this.minVersion = minVersion;
            return this;
        }

        @Generated
        public MobileAppVersionInfoBuilder minVersionReleaseNotes(String minVersionReleaseNotes) {
            this.minVersionReleaseNotes = minVersionReleaseNotes;
            return this;
        }

        @Generated
        public MobileAppVersionInfoBuilder latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        @Generated
        public MobileAppVersionInfoBuilder latestVersionReleaseNotes(String latestVersionReleaseNotes) {
            this.latestVersionReleaseNotes = latestVersionReleaseNotes;
            return this;
        }

        @Generated
        public MobileAppVersionInfo build() {
            return new MobileAppVersionInfo(this.minVersion, this.minVersionReleaseNotes, this.latestVersion, this.latestVersionReleaseNotes);
        }

        @Generated
        public String toString() {
            return "MobileAppVersionInfo.MobileAppVersionInfoBuilder(minVersion=" + this.minVersion + ", minVersionReleaseNotes=" + this.minVersionReleaseNotes + ", latestVersion=" + this.latestVersion + ", latestVersionReleaseNotes=" + this.latestVersionReleaseNotes + ")";
        }
    }
}

