/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.mobile.app;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.MobileAppId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.mobile.app.MobileAppStatus;
import org.thingsboard.server.common.data.mobile.app.MobileAppVersionInfo;
import org.thingsboard.server.common.data.mobile.app.StoreInfo;
import org.thingsboard.server.common.data.oauth2.PlatformType;
import org.thingsboard.server.common.data.validation.Length;

public class MobileApp
extends BaseData<MobileAppId>
implements HasName,
TenantEntity {
    @Schema(description="JSON object with Tenant Id")
    private TenantId tenantId;
    @Schema(description="Application package name. Cannot be empty", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotBlank
    @Length(fieldName="pkgName")
    private String pkgName;
    @Schema(description="Application title")
    @Length(fieldName="title")
    private String title;
    @Schema(description="Application secret. The length must be at least 16 characters", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotEmpty
    @Length(fieldName="appSecret", min=16, max=2048, message="must be at least 16 and max 2048 characters")
    private String appSecret;
    @Schema(description="Application platform type: ANDROID or IOS", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull
    private PlatformType platformType;
    @Schema(description="Application status: PUBLISHED, DEPRECATED, SUSPENDED, DRAFT", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull
    private MobileAppStatus status;
    @Schema(description="Application version info")
    @Valid
    private MobileAppVersionInfo versionInfo;
    @Schema(description="Application store information")
    @Valid
    private StoreInfo storeInfo;

    public MobileApp() {
    }

    public MobileApp(MobileAppId id) {
        super(id);
    }

    public MobileApp(MobileApp mobile) {
        super(mobile);
        this.tenantId = mobile.tenantId;
        this.pkgName = mobile.pkgName;
        this.title = mobile.title;
        this.appSecret = mobile.appSecret;
        this.platformType = mobile.platformType;
        this.status = mobile.status;
        this.versionInfo = mobile.versionInfo;
        this.storeInfo = mobile.storeInfo;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Schema(description="Mobile app package name", example="my.mobile.app", accessMode=Schema.AccessMode.READ_ONLY)
    public String getName() {
        return this.pkgName;
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.MOBILE_APP;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MobileApp)) {
            return false;
        }
        MobileApp other = (MobileApp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$pkgName = this.getPkgName();
        String other$pkgName = other.getPkgName();
        if (this$pkgName == null ? other$pkgName != null : !this$pkgName.equals(other$pkgName)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$appSecret = this.getAppSecret();
        String other$appSecret = other.getAppSecret();
        if (this$appSecret == null ? other$appSecret != null : !this$appSecret.equals(other$appSecret)) {
            return false;
        }
        PlatformType this$platformType = this.getPlatformType();
        PlatformType other$platformType = other.getPlatformType();
        if (this$platformType == null ? other$platformType != null : !((Object)((Object)this$platformType)).equals((Object)other$platformType)) {
            return false;
        }
        MobileAppStatus this$status = this.getStatus();
        MobileAppStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        MobileAppVersionInfo this$versionInfo = this.getVersionInfo();
        MobileAppVersionInfo other$versionInfo = other.getVersionInfo();
        if (this$versionInfo == null ? other$versionInfo != null : !((Object)this$versionInfo).equals(other$versionInfo)) {
            return false;
        }
        StoreInfo this$storeInfo = this.getStoreInfo();
        StoreInfo other$storeInfo = other.getStoreInfo();
        return !(this$storeInfo == null ? other$storeInfo != null : !((Object)this$storeInfo).equals(other$storeInfo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MobileApp;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $pkgName = this.getPkgName();
        result = result * 59 + ($pkgName == null ? 43 : $pkgName.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $appSecret = this.getAppSecret();
        result = result * 59 + ($appSecret == null ? 43 : $appSecret.hashCode());
        PlatformType $platformType = this.getPlatformType();
        result = result * 59 + ($platformType == null ? 43 : ((Object)((Object)$platformType)).hashCode());
        MobileAppStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        MobileAppVersionInfo $versionInfo = this.getVersionInfo();
        result = result * 59 + ($versionInfo == null ? 43 : ((Object)$versionInfo).hashCode());
        StoreInfo $storeInfo = this.getStoreInfo();
        result = result * 59 + ($storeInfo == null ? 43 : ((Object)$storeInfo).hashCode());
        return result;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getPkgName() {
        return this.pkgName;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getAppSecret() {
        return this.appSecret;
    }

    @Generated
    public PlatformType getPlatformType() {
        return this.platformType;
    }

    @Generated
    public MobileAppStatus getStatus() {
        return this.status;
    }

    @Generated
    public MobileAppVersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @Generated
    public StoreInfo getStoreInfo() {
        return this.storeInfo;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setPkgName(String pkgName) {
        this.pkgName = pkgName;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @Generated
    public void setPlatformType(PlatformType platformType) {
        this.platformType = platformType;
    }

    @Generated
    public void setStatus(MobileAppStatus status) {
        this.status = status;
    }

    @Generated
    public void setVersionInfo(MobileAppVersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    @Generated
    public void setStoreInfo(StoreInfo storeInfo) {
        this.storeInfo = storeInfo;
    }

    @Override
    @Generated
    public String toString() {
        return "MobileApp(tenantId=" + String.valueOf(this.getTenantId()) + ", pkgName=" + this.getPkgName() + ", title=" + this.getTitle() + ", appSecret=" + this.getAppSecret() + ", platformType=" + String.valueOf((Object)this.getPlatformType()) + ", status=" + String.valueOf((Object)this.getStatus()) + ", versionInfo=" + String.valueOf(this.getVersionInfo()) + ", storeInfo=" + String.valueOf(this.getStoreInfo()) + ")";
    }
}

