/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.menu;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.CustomMenuId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.menu.CMAssigneeType;
import org.thingsboard.server.common.data.menu.CMScope;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class CustomMenuInfo
extends BaseData<CustomMenuId>
implements HasTenantId {
    @Schema(description="JSON object with Tenant Id that owns the menu.", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @Schema(description="JSON object with Customer Id that owns the menu.", accessMode=Schema.AccessMode.READ_ONLY)
    private CustomerId customerId;
    @NoXss
    @Length(fieldName="name")
    @Schema(description="Custom menu name", example="Customer A custom menu", requiredMode=Schema.RequiredMode.REQUIRED)
    private String name;
    @NotNull
    @Schema(description="Custom menu scope. Possible values: SYSTEM, TENANT, CUSTOMER", example="TENANT", requiredMode=Schema.RequiredMode.REQUIRED)
    private CMScope scope;
    @NotNull
    @Schema(description="Custom menu assignee type. Possible values are: All (all users of specified scope), CUSTOMERS (specified customers), USERS (specified list of users), NO_ASSIGN (no assignees)", example="ALL", requiredMode=Schema.RequiredMode.REQUIRED)
    private CMAssigneeType assigneeType;

    public CustomMenuInfo() {
    }

    public CustomMenuInfo(CustomMenuId id) {
        super(id);
    }

    public CustomMenuInfo(CustomMenuInfo customMenuInfo) {
        super(customMenuInfo);
        this.tenantId = customMenuInfo.getTenantId();
        this.customerId = customMenuInfo.getCustomerId();
        this.name = customMenuInfo.getName();
        this.scope = customMenuInfo.getScope();
        this.assigneeType = customMenuInfo.getAssigneeType();
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public CMScope getScope() {
        return this.scope;
    }

    @Generated
    public CMAssigneeType getAssigneeType() {
        return this.assigneeType;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setScope(CMScope scope) {
        this.scope = scope;
    }

    @Generated
    public void setAssigneeType(CMAssigneeType assigneeType) {
        this.assigneeType = assigneeType;
    }

    @Override
    @Generated
    public String toString() {
        return "CustomMenuInfo(tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", name=" + this.getName() + ", scope=" + String.valueOf((Object)this.getScope()) + ", assigneeType=" + String.valueOf((Object)this.getAssigneeType()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomMenuInfo)) {
            return false;
        }
        CustomMenuInfo other = (CustomMenuInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        CMScope this$scope = this.getScope();
        CMScope other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
            return false;
        }
        CMAssigneeType this$assigneeType = this.getAssigneeType();
        CMAssigneeType other$assigneeType = other.getAssigneeType();
        return !(this$assigneeType == null ? other$assigneeType != null : !((Object)((Object)this$assigneeType)).equals((Object)other$assigneeType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomMenuInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        CMScope $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
        CMAssigneeType $assigneeType = this.getAssigneeType();
        result = result * 59 + ($assigneeType == null ? 43 : ((Object)((Object)$assigneeType)).hashCode());
        return result;
    }
}

