/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.kv;

import jakarta.validation.Valid;
import java.util.Optional;
import lombok.Generated;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;

public class BasicTsKvEntry
implements TsKvEntry {
    private static final int MAX_CHARS_PER_DATA_POINT = 512;
    protected final long ts;
    @Valid
    private final KvEntry kv;
    private final Long version;

    public BasicTsKvEntry(long ts, KvEntry kv) {
        this.ts = ts;
        this.kv = kv;
        this.version = null;
    }

    public BasicTsKvEntry(long ts, KvEntry kv, Long version) {
        this.ts = ts;
        this.kv = kv;
        this.version = version;
    }

    @Override
    public String getKey() {
        return this.kv.getKey();
    }

    @Override
    public DataType getDataType() {
        return this.kv.getDataType();
    }

    @Override
    public Optional<String> getStrValue() {
        return this.kv.getStrValue();
    }

    @Override
    public Optional<Long> getLongValue() {
        return this.kv.getLongValue();
    }

    @Override
    public Optional<Boolean> getBooleanValue() {
        return this.kv.getBooleanValue();
    }

    @Override
    public Optional<Double> getDoubleValue() {
        return this.kv.getDoubleValue();
    }

    @Override
    public Optional<String> getJsonValue() {
        return this.kv.getJsonValue();
    }

    @Override
    public Object getValue() {
        return this.kv.getValue();
    }

    @Override
    public String getValueAsString() {
        return this.kv.getValueAsString();
    }

    @Override
    public int getDataPoints() {
        int length;
        switch (this.getDataType()) {
            case STRING: {
                length = this.getStrValue().get().length();
                break;
            }
            case JSON: {
                length = this.getJsonValue().get().length();
                break;
            }
            default: {
                return 1;
            }
        }
        return Math.max(1, (length + 512 - 1) / 512);
    }

    @Override
    @Generated
    public long getTs() {
        return this.ts;
    }

    @Generated
    public KvEntry getKv() {
        return this.kv;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicTsKvEntry)) {
            return false;
        }
        BasicTsKvEntry other = (BasicTsKvEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        KvEntry this$kv = this.getKv();
        KvEntry other$kv = other.getKv();
        return !(this$kv == null ? other$kv != null : !this$kv.equals(other$kv));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BasicTsKvEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        KvEntry $kv = this.getKv();
        result = result * 59 + ($kv == null ? 43 : $kv.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BasicTsKvEntry(ts=" + this.getTs() + ", kv=" + String.valueOf(this.getKv()) + ", version=" + this.getVersion() + ")";
    }
}

