/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.kv;

import java.beans.ConstructorProperties;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.IntervalType;

public class AggregationParams {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AggregationParams.class);
    private static final Map<String, String> TZ_LINKS = Map.of("EST", "America/New_York", "GMT+0", "GMT", "GMT-0", "GMT", "HST", "US/Hawaii", "MST", "America/Phoenix", "ROC", "Asia/Taipei");
    private final Aggregation aggregation;
    private final IntervalType intervalType;
    private final ZoneId tzId;
    private final long interval;

    public static AggregationParams none() {
        return new AggregationParams(Aggregation.NONE, null, null, 0L);
    }

    public static AggregationParams milliseconds(Aggregation aggregationType, long aggregationIntervalMs) {
        return new AggregationParams(aggregationType, IntervalType.MILLISECONDS, null, aggregationIntervalMs);
    }

    public static AggregationParams calendar(Aggregation aggregationType, IntervalType intervalType, String tzIdStr) {
        return AggregationParams.calendar(aggregationType, intervalType, AggregationParams.getZoneId(tzIdStr));
    }

    public static AggregationParams calendar(Aggregation aggregationType, IntervalType intervalType, ZoneId tzId) {
        return new AggregationParams(aggregationType, intervalType, tzId, 0L);
    }

    public static AggregationParams of(Aggregation aggregation, IntervalType intervalType, ZoneId tzId, long interval) {
        return new AggregationParams(aggregation, intervalType, tzId, interval);
    }

    public long getInterval() {
        if (this.intervalType == null) {
            return 0L;
        }
        switch (this.intervalType) {
            case WEEK: 
            case WEEK_ISO: {
                return TimeUnit.DAYS.toMillis(7L);
            }
            case MONTH: {
                return TimeUnit.DAYS.toMillis(30L);
            }
            case QUARTER: {
                return TimeUnit.DAYS.toMillis(90L);
            }
        }
        return this.interval;
    }

    private static ZoneId getZoneId(String tzIdStr) {
        if (StringUtils.isEmpty(tzIdStr)) {
            return ZoneId.systemDefault();
        }
        try {
            return ZoneId.of(tzIdStr, TZ_LINKS);
        }
        catch (DateTimeException e) {
            log.warn("[{}] Failed to convert the time zone. Fallback to default.", (Object)tzIdStr);
            return ZoneId.systemDefault();
        }
    }

    @ConstructorProperties(value={"aggregation", "intervalType", "tzId", "interval"})
    @Generated
    public AggregationParams(Aggregation aggregation, IntervalType intervalType, ZoneId tzId, long interval) {
        this.aggregation = aggregation;
        this.intervalType = intervalType;
        this.tzId = tzId;
        this.interval = interval;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregationParams)) {
            return false;
        }
        AggregationParams other = (AggregationParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInterval() != other.getInterval()) {
            return false;
        }
        Aggregation this$aggregation = this.getAggregation();
        Aggregation other$aggregation = other.getAggregation();
        if (this$aggregation == null ? other$aggregation != null : !((Object)((Object)this$aggregation)).equals((Object)other$aggregation)) {
            return false;
        }
        IntervalType this$intervalType = this.getIntervalType();
        IntervalType other$intervalType = other.getIntervalType();
        if (this$intervalType == null ? other$intervalType != null : !((Object)((Object)this$intervalType)).equals((Object)other$intervalType)) {
            return false;
        }
        ZoneId this$tzId = this.getTzId();
        ZoneId other$tzId = other.getTzId();
        return !(this$tzId == null ? other$tzId != null : !((Object)this$tzId).equals(other$tzId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AggregationParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $interval = this.getInterval();
        result = result * 59 + (int)($interval >>> 32 ^ $interval);
        Aggregation $aggregation = this.getAggregation();
        result = result * 59 + ($aggregation == null ? 43 : ((Object)((Object)$aggregation)).hashCode());
        IntervalType $intervalType = this.getIntervalType();
        result = result * 59 + ($intervalType == null ? 43 : ((Object)((Object)$intervalType)).hashCode());
        ZoneId $tzId = this.getTzId();
        result = result * 59 + ($tzId == null ? 43 : ((Object)$tzId).hashCode());
        return result;
    }

    @Generated
    public Aggregation getAggregation() {
        return this.aggregation;
    }

    @Generated
    public IntervalType getIntervalType() {
        return this.intervalType;
    }

    @Generated
    public ZoneId getTzId() {
        return this.tzId;
    }
}

