/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.integration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.debug.DebugSettings;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.AbstractIntegration;
import org.thingsboard.server.common.data.integration.IntegrationType;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
@JsonIgnoreProperties(ignoreUnknown=true)
public class Integration
extends AbstractIntegration
implements ExportableEntity<IntegrationId> {
    private static final long serialVersionUID = 4934987577236873728L;
    private ConverterId defaultConverterId;
    private ConverterId downlinkConverterId;
    @NoXss
    @Length(fieldName="routingKey")
    private String routingKey;
    @NoXss
    @Length(fieldName="secret")
    private String secret;
    private JsonNode configuration;
    @NoXss
    private JsonNode additionalInfo;
    private IntegrationId externalId;

    public Integration() {
    }

    public Integration(IntegrationId id) {
        super(id);
    }

    public Integration(Integration integration) {
        super(integration);
        this.defaultConverterId = integration.getDefaultConverterId();
        this.downlinkConverterId = integration.getDownlinkConverterId();
        this.routingKey = integration.getRoutingKey();
        this.secret = integration.getSecret();
        this.configuration = integration.getConfiguration().deepCopy();
        this.additionalInfo = integration.getAdditionalInfo();
        this.externalId = integration.getExternalId();
    }

    @Override
    @Schema(description="JSON object with the Integration Id. Specify this field to update the Integration. Referencing non-existing Integration Id will cause error. Omit this field to create new Integration.")
    public IntegrationId getId() {
        return super.getId();
    }

    @Override
    @Schema(description="Timestamp of the integration creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Schema(description="JSON object with the Uplink Converter Id", requiredMode=Schema.RequiredMode.REQUIRED)
    public ConverterId getDefaultConverterId() {
        return this.defaultConverterId;
    }

    public void setDefaultConverterId(ConverterId defaultConverterId) {
        this.defaultConverterId = defaultConverterId;
    }

    @Schema(description="JSON object with the Downlink Converter Id")
    public ConverterId getDownlinkConverterId() {
        return this.downlinkConverterId;
    }

    public void setDownlinkConverterId(ConverterId downlinkConverterId) {
        this.downlinkConverterId = downlinkConverterId;
    }

    @Schema(description="String value used by HTTP based integrations for the base URL construction and by the remote integrations. Remote integration uses this value along with the 'secret' for kind of security and validation to be able to connect to the platform using Grpc", requiredMode=Schema.RequiredMode.REQUIRED, example="ca1a01b6-4ca1-3da5-54e4-a07090b65644")
    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    @Schema(description="String value used by the remote integrations. Remote integration uses this value along with the 'routingKey' for kind of security and validation to be able to connect to the platform using Grpc", example="nl83m1ktpwpwwmww29sm")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Schema(description="JSON object representing integration configuration. Each integration type has specific configuration with the connectivity parameters (like 'host' and 'port' for MQTT type or 'baseUrl' for HTTP based type, etc.) and other important parameters dependent on the integration type", requiredMode=Schema.RequiredMode.REQUIRED)
    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    @Schema(description="Additional parameters of the integration", implementation=JsonNode.class)
    public JsonNode getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(JsonNode additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.INTEGRATION;
    }

    public Integration(TenantId tenantId, String name, IntegrationType type, Boolean enabled, Boolean isRemote, Boolean allowCreateDevicesOrAssets, boolean isEdgeTemplate, ConverterId defaultConverterId, ConverterId downlinkConverterId, String routingKey, DebugSettings debugSettings, String secret, JsonNode configuration, JsonNode additionalInfo, IntegrationId externalId, Long version) {
        super(tenantId, name, type, false, debugSettings, enabled, isRemote, allowCreateDevicesOrAssets, isEdgeTemplate, version);
        this.defaultConverterId = defaultConverterId;
        this.downlinkConverterId = downlinkConverterId;
        this.routingKey = routingKey;
        this.secret = secret;
        this.configuration = configuration;
        this.additionalInfo = additionalInfo;
        this.externalId = externalId;
    }

    @Generated
    public static IntegrationBuilder builder() {
        return new IntegrationBuilder();
    }

    @Override
    @Generated
    public String toString() {
        return "Integration(super=" + super.toString() + ", defaultConverterId=" + String.valueOf(this.getDefaultConverterId()) + ", downlinkConverterId=" + String.valueOf(this.getDownlinkConverterId()) + ", routingKey=" + this.getRoutingKey() + ", secret=" + this.getSecret() + ", configuration=" + String.valueOf(this.getConfiguration()) + ", additionalInfo=" + String.valueOf(this.getAdditionalInfo()) + ", externalId=" + String.valueOf(this.getExternalId()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Integration)) {
            return false;
        }
        Integration other = (Integration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConverterId this$defaultConverterId = this.getDefaultConverterId();
        ConverterId other$defaultConverterId = other.getDefaultConverterId();
        if (this$defaultConverterId == null ? other$defaultConverterId != null : !((Object)this$defaultConverterId).equals(other$defaultConverterId)) {
            return false;
        }
        ConverterId this$downlinkConverterId = this.getDownlinkConverterId();
        ConverterId other$downlinkConverterId = other.getDownlinkConverterId();
        if (this$downlinkConverterId == null ? other$downlinkConverterId != null : !((Object)this$downlinkConverterId).equals(other$downlinkConverterId)) {
            return false;
        }
        String this$routingKey = this.getRoutingKey();
        String other$routingKey = other.getRoutingKey();
        if (this$routingKey == null ? other$routingKey != null : !this$routingKey.equals(other$routingKey)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        JsonNode this$configuration = this.getConfiguration();
        JsonNode other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        JsonNode this$additionalInfo = this.getAdditionalInfo();
        JsonNode other$additionalInfo = other.getAdditionalInfo();
        if (this$additionalInfo == null ? other$additionalInfo != null : !this$additionalInfo.equals(other$additionalInfo)) {
            return false;
        }
        IntegrationId this$externalId = this.getExternalId();
        IntegrationId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Integration;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ConverterId $defaultConverterId = this.getDefaultConverterId();
        result = result * 59 + ($defaultConverterId == null ? 43 : ((Object)$defaultConverterId).hashCode());
        ConverterId $downlinkConverterId = this.getDownlinkConverterId();
        result = result * 59 + ($downlinkConverterId == null ? 43 : ((Object)$downlinkConverterId).hashCode());
        String $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : $routingKey.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        JsonNode $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        JsonNode $additionalInfo = this.getAdditionalInfo();
        result = result * 59 + ($additionalInfo == null ? 43 : $additionalInfo.hashCode());
        IntegrationId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }

    @Override
    @Generated
    public IntegrationId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public void setExternalId(IntegrationId externalId) {
        this.externalId = externalId;
    }

    @Generated
    public static class IntegrationBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private String name;
        @Generated
        private IntegrationType type;
        @Generated
        private Boolean enabled;
        @Generated
        private Boolean isRemote;
        @Generated
        private Boolean allowCreateDevicesOrAssets;
        @Generated
        private boolean isEdgeTemplate;
        @Generated
        private ConverterId defaultConverterId;
        @Generated
        private ConverterId downlinkConverterId;
        @Generated
        private String routingKey;
        @Generated
        private DebugSettings debugSettings;
        @Generated
        private String secret;
        @Generated
        private JsonNode configuration;
        @Generated
        private JsonNode additionalInfo;
        @Generated
        private IntegrationId externalId;
        @Generated
        private Long version;

        @Generated
        IntegrationBuilder() {
        }

        @Generated
        public IntegrationBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public IntegrationBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public IntegrationBuilder type(IntegrationType type) {
            this.type = type;
            return this;
        }

        @Generated
        public IntegrationBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public IntegrationBuilder isRemote(Boolean isRemote) {
            this.isRemote = isRemote;
            return this;
        }

        @Generated
        public IntegrationBuilder allowCreateDevicesOrAssets(Boolean allowCreateDevicesOrAssets) {
            this.allowCreateDevicesOrAssets = allowCreateDevicesOrAssets;
            return this;
        }

        @Generated
        public IntegrationBuilder isEdgeTemplate(boolean isEdgeTemplate) {
            this.isEdgeTemplate = isEdgeTemplate;
            return this;
        }

        @Generated
        public IntegrationBuilder defaultConverterId(ConverterId defaultConverterId) {
            this.defaultConverterId = defaultConverterId;
            return this;
        }

        @Generated
        public IntegrationBuilder downlinkConverterId(ConverterId downlinkConverterId) {
            this.downlinkConverterId = downlinkConverterId;
            return this;
        }

        @Generated
        public IntegrationBuilder routingKey(String routingKey) {
            this.routingKey = routingKey;
            return this;
        }

        @Generated
        public IntegrationBuilder debugSettings(DebugSettings debugSettings) {
            this.debugSettings = debugSettings;
            return this;
        }

        @Generated
        public IntegrationBuilder secret(String secret) {
            this.secret = secret;
            return this;
        }

        @Generated
        public IntegrationBuilder configuration(JsonNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public IntegrationBuilder additionalInfo(JsonNode additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        @Generated
        public IntegrationBuilder externalId(IntegrationId externalId) {
            this.externalId = externalId;
            return this;
        }

        @Generated
        public IntegrationBuilder version(Long version) {
            this.version = version;
            return this;
        }

        @Generated
        public Integration build() {
            return new Integration(this.tenantId, this.name, this.type, this.enabled, this.isRemote, this.allowCreateDevicesOrAssets, this.isEdgeTemplate, this.defaultConverterId, this.downlinkConverterId, this.routingKey, this.debugSettings, this.secret, this.configuration, this.additionalInfo, this.externalId, this.version);
        }

        @Generated
        public String toString() {
            return "Integration.IntegrationBuilder(tenantId=" + String.valueOf(this.tenantId) + ", name=" + this.name + ", type=" + String.valueOf((Object)this.type) + ", enabled=" + this.enabled + ", isRemote=" + this.isRemote + ", allowCreateDevicesOrAssets=" + this.allowCreateDevicesOrAssets + ", isEdgeTemplate=" + this.isEdgeTemplate + ", defaultConverterId=" + String.valueOf(this.defaultConverterId) + ", downlinkConverterId=" + String.valueOf(this.downlinkConverterId) + ", routingKey=" + this.routingKey + ", debugSettings=" + String.valueOf(this.debugSettings) + ", secret=" + this.secret + ", configuration=" + String.valueOf(this.configuration) + ", additionalInfo=" + String.valueOf(this.additionalInfo) + ", externalId=" + String.valueOf(this.externalId) + ", version=" + this.version + ")";
        }
    }
}

