/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.integration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasDebugSettings;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.debug.DebugSettings;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.IntegrationType;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public abstract class AbstractIntegration
extends BaseData<IntegrationId>
implements HasName,
TenantEntity,
HasVersion,
HasDebugSettings {
    private static final long serialVersionUID = 1934983577296873728L;
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="name")
    private String name;
    private IntegrationType type;
    @Deprecated
    private boolean debugMode;
    private DebugSettings debugSettings;
    private Boolean enabled;
    private Boolean isRemote;
    private Boolean allowCreateDevicesOrAssets;
    private boolean isEdgeTemplate;
    private Long version;

    public AbstractIntegration() {
    }

    public AbstractIntegration(IntegrationId id) {
        super(id);
    }

    public AbstractIntegration(AbstractIntegration integration) {
        super(integration);
        this.tenantId = integration.getTenantId();
        this.name = integration.getName();
        this.type = integration.getType();
        this.debugSettings = integration.getDebugSettings();
        this.enabled = integration.isEnabled();
        this.isRemote = integration.isRemote();
        this.allowCreateDevicesOrAssets = integration.isAllowCreateDevicesOrAssets();
        this.isEdgeTemplate = integration.isEdgeTemplate();
        this.version = integration.getVersion();
    }

    @Override
    @Schema(description="JSON object with the Integration Id. Specify this field to update the Integration. Referencing non-existing Integration Id will cause error. Omit this field to create new Integration.")
    public IntegrationId getId() {
        return (IntegrationId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the integration creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Schema(description="JSON object with Tenant Id", accessMode=Schema.AccessMode.READ_ONLY)
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The type of the integration")
    public IntegrationType getType() {
        return this.type;
    }

    public void setType(IntegrationType type) {
        this.type = type;
    }

    @Override
    @Schema(description="Enable/disable debug. ", example="false", deprecated=true)
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    @Deprecated
    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    @Schema(description="Debug settings object.")
    public DebugSettings getDebugSettings() {
        return this.debugSettings;
    }

    @Override
    public void setDebugSettings(DebugSettings debugSettings) {
        this.debugSettings = debugSettings;
    }

    @Schema(description="Boolean flag to enable/disable the integration")
    public Boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Schema(description="Boolean flag to enable/disable the integration to be executed remotely. Remote integration is launched in a separate microservice. Local integration is executed by the platform core")
    public Boolean isRemote() {
        return this.isRemote != null && this.isRemote != false;
    }

    public void setRemote(Boolean remote) {
        this.isRemote = remote;
    }

    @Schema(description="Boolean flag to allow/disallow the integration to create devices or assets that send message and do not exist in the system yet")
    public Boolean isAllowCreateDevicesOrAssets() {
        return this.allowCreateDevicesOrAssets != null && this.allowCreateDevicesOrAssets != false;
    }

    public void setAllowCreateDevicesOrAssets(Boolean allow) {
        this.allowCreateDevicesOrAssets = allow;
    }

    @Override
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Integration Name", example="Http Integration")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="Boolean flag that specifies that is regular or edge template integration")
    public boolean isEdgeTemplate() {
        return this.isEdgeTemplate;
    }

    public void setEdgeTemplate(boolean edgeTemplate) {
        this.isEdgeTemplate = edgeTemplate;
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.INTEGRATION;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractIntegration)) {
            return false;
        }
        AbstractIntegration other = (AbstractIntegration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDebugMode() != other.isDebugMode()) {
            return false;
        }
        if (this.isEdgeTemplate() != other.isEdgeTemplate()) {
            return false;
        }
        Boolean this$enabled = this.enabled;
        Boolean other$enabled = other.enabled;
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$isRemote = this.isRemote;
        Boolean other$isRemote = other.isRemote;
        if (this$isRemote == null ? other$isRemote != null : !((Object)this$isRemote).equals(other$isRemote)) {
            return false;
        }
        Boolean this$allowCreateDevicesOrAssets = this.allowCreateDevicesOrAssets;
        Boolean other$allowCreateDevicesOrAssets = other.allowCreateDevicesOrAssets;
        if (this$allowCreateDevicesOrAssets == null ? other$allowCreateDevicesOrAssets != null : !((Object)this$allowCreateDevicesOrAssets).equals(other$allowCreateDevicesOrAssets)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        IntegrationType this$type = this.getType();
        IntegrationType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        DebugSettings this$debugSettings = this.getDebugSettings();
        DebugSettings other$debugSettings = other.getDebugSettings();
        return !(this$debugSettings == null ? other$debugSettings != null : !((Object)this$debugSettings).equals(other$debugSettings));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractIntegration;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDebugMode() ? 79 : 97);
        result = result * 59 + (this.isEdgeTemplate() ? 79 : 97);
        Boolean $enabled = this.enabled;
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $isRemote = this.isRemote;
        result = result * 59 + ($isRemote == null ? 43 : ((Object)$isRemote).hashCode());
        Boolean $allowCreateDevicesOrAssets = this.allowCreateDevicesOrAssets;
        result = result * 59 + ($allowCreateDevicesOrAssets == null ? 43 : ((Object)$allowCreateDevicesOrAssets).hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        IntegrationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        DebugSettings $debugSettings = this.getDebugSettings();
        result = result * 59 + ($debugSettings == null ? 43 : ((Object)$debugSettings).hashCode());
        return result;
    }

    @ConstructorProperties(value={"tenantId", "name", "type", "debugMode", "debugSettings", "enabled", "isRemote", "allowCreateDevicesOrAssets", "isEdgeTemplate", "version"})
    @Generated
    public AbstractIntegration(TenantId tenantId, String name, IntegrationType type, boolean debugMode, DebugSettings debugSettings, Boolean enabled, Boolean isRemote, Boolean allowCreateDevicesOrAssets, boolean isEdgeTemplate, Long version) {
        this.tenantId = tenantId;
        this.name = name;
        this.type = type;
        this.debugMode = debugMode;
        this.debugSettings = debugSettings;
        this.enabled = enabled;
        this.isRemote = isRemote;
        this.allowCreateDevicesOrAssets = allowCreateDevicesOrAssets;
        this.isEdgeTemplate = isEdgeTemplate;
        this.version = version;
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractIntegration(super=" + super.toString() + ", tenantId=" + String.valueOf(this.getTenantId()) + ", name=" + this.getName() + ", type=" + String.valueOf((Object)this.getType()) + ", debugMode=" + this.isDebugMode() + ", debugSettings=" + String.valueOf(this.getDebugSettings()) + ", enabled=" + this.enabled + ", isRemote=" + this.isRemote + ", allowCreateDevicesOrAssets=" + this.allowCreateDevicesOrAssets + ", isEdgeTemplate=" + this.isEdgeTemplate() + ", version=" + this.getVersion() + ")";
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }
}

