/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.id;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.UUID;
import org.thingsboard.server.common.data.id.HasUUID;

@Schema
public abstract class UUIDBased
implements HasUUID,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient int hash;
    private final UUID id;

    public UUIDBased() {
        this(UUID.randomUUID());
    }

    public UUIDBased(UUID id) {
        this.id = id;
    }

    @Override
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="string", example="784f394c-42b6-435a-983c-b7beff2784f9")
    public UUID getId() {
        return this.id;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int prime = 31;
            int result = 1;
            this.hash = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UUIDBased other = (UUIDBased)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return String.valueOf(this.id);
    }
}

