/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.id;

import java.util.UUID;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.AdminSettingsId;
import org.thingsboard.server.common.data.id.AiModelId;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.ApiUsageStateId;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.BlobEntityId;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.CalculatedFieldLinkId;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.DomainId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.GroupPermissionId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.JobId;
import org.thingsboard.server.common.data.id.MobileAppBundleId;
import org.thingsboard.server.common.data.id.MobileAppId;
import org.thingsboard.server.common.data.id.NotificationId;
import org.thingsboard.server.common.data.id.NotificationRequestId;
import org.thingsboard.server.common.data.id.NotificationRuleId;
import org.thingsboard.server.common.data.id.NotificationTargetId;
import org.thingsboard.server.common.data.id.NotificationTemplateId;
import org.thingsboard.server.common.data.id.OAuth2ClientId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.QueueId;
import org.thingsboard.server.common.data.id.QueueStatsId;
import org.thingsboard.server.common.data.id.ReportId;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.RpcId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.SecretId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;

public class EntityIdFactory {
    public static EntityId getByTypeAndUuid(int type, String uuid) {
        return EntityIdFactory.getByTypeAndUuid(EntityType.values()[type], UUID.fromString(uuid));
    }

    public static EntityId getByTypeAndUuid(int type, UUID uuid) {
        return EntityIdFactory.getByTypeAndUuid(EntityType.values()[type], uuid);
    }

    public static EntityId getByTypeAndUuid(String type, String uuid) {
        return EntityIdFactory.getByTypeAndUuid(EntityType.valueOf(type), UUID.fromString(uuid));
    }

    public static EntityId getByTypeAndId(String type, String uuid) {
        return EntityIdFactory.getByTypeAndUuid(EntityType.valueOf(type), UUID.fromString(uuid));
    }

    public static EntityId getByTypeAndId(EntityType type, String uuid) {
        return EntityIdFactory.getByTypeAndUuid(type, UUID.fromString(uuid));
    }

    public static EntityId getByTypeAndUuid(String type, UUID uuid) {
        return EntityIdFactory.getByTypeAndUuid(EntityType.valueOf(type), uuid);
    }

    public static EntityId getByTypeAndUuid(EntityType type, String uuid) {
        return EntityIdFactory.getByTypeAndUuid(type, UUID.fromString(uuid));
    }

    public static EntityId getByTypeAndUuid(EntityType type, UUID uuid) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case EntityType.TENANT -> TenantId.fromUUID(uuid);
            case EntityType.CUSTOMER -> new CustomerId(uuid);
            case EntityType.USER -> new UserId(uuid);
            case EntityType.DASHBOARD -> new DashboardId(uuid);
            case EntityType.DEVICE -> new DeviceId(uuid);
            case EntityType.ASSET -> new AssetId(uuid);
            case EntityType.CONVERTER -> new ConverterId(uuid);
            case EntityType.INTEGRATION -> new IntegrationId(uuid);
            case EntityType.ALARM -> new AlarmId(uuid);
            case EntityType.ENTITY_GROUP -> new EntityGroupId(uuid);
            case EntityType.RULE_CHAIN -> new RuleChainId(uuid);
            case EntityType.RULE_NODE -> new RuleNodeId(uuid);
            case EntityType.SCHEDULER_EVENT -> new SchedulerEventId(uuid);
            case EntityType.BLOB_ENTITY -> new BlobEntityId(uuid);
            case EntityType.REPORT_TEMPLATE -> new ReportTemplateId(uuid);
            case EntityType.REPORT -> new ReportId(uuid);
            case EntityType.ENTITY_VIEW -> new EntityViewId(uuid);
            case EntityType.ROLE -> new RoleId(uuid);
            case EntityType.GROUP_PERMISSION -> new GroupPermissionId(uuid);
            case EntityType.WIDGETS_BUNDLE -> new WidgetsBundleId(uuid);
            case EntityType.WIDGET_TYPE -> new WidgetTypeId(uuid);
            case EntityType.DEVICE_PROFILE -> new DeviceProfileId(uuid);
            case EntityType.ASSET_PROFILE -> new AssetProfileId(uuid);
            case EntityType.TENANT_PROFILE -> new TenantProfileId(uuid);
            case EntityType.API_USAGE_STATE -> new ApiUsageStateId(uuid);
            case EntityType.TB_RESOURCE -> new TbResourceId(uuid);
            case EntityType.OTA_PACKAGE -> new OtaPackageId(uuid);
            case EntityType.EDGE -> new EdgeId(uuid);
            case EntityType.RPC -> new RpcId(uuid);
            case EntityType.QUEUE -> new QueueId(uuid);
            case EntityType.NOTIFICATION_TARGET -> new NotificationTargetId(uuid);
            case EntityType.NOTIFICATION_REQUEST -> new NotificationRequestId(uuid);
            case EntityType.NOTIFICATION_RULE -> new NotificationRuleId(uuid);
            case EntityType.NOTIFICATION_TEMPLATE -> new NotificationTemplateId(uuid);
            case EntityType.NOTIFICATION -> new NotificationId(uuid);
            case EntityType.QUEUE_STATS -> new QueueStatsId(uuid);
            case EntityType.OAUTH2_CLIENT -> new OAuth2ClientId(uuid);
            case EntityType.MOBILE_APP -> new MobileAppId(uuid);
            case EntityType.DOMAIN -> new DomainId(uuid);
            case EntityType.MOBILE_APP_BUNDLE -> new MobileAppBundleId(uuid);
            case EntityType.CALCULATED_FIELD -> new CalculatedFieldId(uuid);
            case EntityType.CALCULATED_FIELD_LINK -> new CalculatedFieldLinkId(uuid);
            case EntityType.JOB -> new JobId(uuid);
            case EntityType.SECRET -> new SecretId(uuid);
            case EntityType.ADMIN_SETTINGS -> new AdminSettingsId(uuid);
            case EntityType.AI_MODEL -> new AiModelId(uuid);
        };
    }

    public static EntityId getByEdgeEventTypeAndUuid(EdgeEventType edgeEventType, UUID uuid) {
        return switch (edgeEventType) {
            case EdgeEventType.TENANT -> TenantId.fromUUID(uuid);
            case EdgeEventType.CUSTOMER -> new CustomerId(uuid);
            case EdgeEventType.USER -> new UserId(uuid);
            case EdgeEventType.DASHBOARD -> new DashboardId(uuid);
            case EdgeEventType.DEVICE -> new DeviceId(uuid);
            case EdgeEventType.ASSET -> new AssetId(uuid);
            case EdgeEventType.ALARM -> new AlarmId(uuid);
            case EdgeEventType.RULE_CHAIN -> new RuleChainId(uuid);
            case EdgeEventType.ENTITY_VIEW -> new EntityViewId(uuid);
            case EdgeEventType.WIDGETS_BUNDLE -> new WidgetsBundleId(uuid);
            case EdgeEventType.WIDGET_TYPE -> new WidgetTypeId(uuid);
            case EdgeEventType.DEVICE_PROFILE -> new DeviceProfileId(uuid);
            case EdgeEventType.ASSET_PROFILE -> new AssetProfileId(uuid);
            case EdgeEventType.TENANT_PROFILE -> new TenantProfileId(uuid);
            case EdgeEventType.OTA_PACKAGE -> new OtaPackageId(uuid);
            case EdgeEventType.EDGE -> EdgeId.fromUUID(uuid);
            case EdgeEventType.SCHEDULER_EVENT -> new SchedulerEventId(uuid);
            case EdgeEventType.ENTITY_GROUP, EdgeEventType.DEVICE_GROUP_OTA -> new EntityGroupId(uuid);
            case EdgeEventType.ROLE -> new RoleId(uuid);
            case EdgeEventType.GROUP_PERMISSION -> new GroupPermissionId(uuid);
            case EdgeEventType.INTEGRATION -> new IntegrationId(uuid);
            case EdgeEventType.CONVERTER -> new ConverterId(uuid);
            case EdgeEventType.QUEUE -> new QueueId(uuid);
            case EdgeEventType.TB_RESOURCE -> new TbResourceId(uuid);
            case EdgeEventType.NOTIFICATION_RULE -> new NotificationRuleId(uuid);
            case EdgeEventType.NOTIFICATION_TARGET -> new NotificationTargetId(uuid);
            case EdgeEventType.NOTIFICATION_TEMPLATE -> new NotificationTemplateId(uuid);
            case EdgeEventType.OAUTH2_CLIENT -> new OAuth2ClientId(uuid);
            case EdgeEventType.DOMAIN -> new DomainId(uuid);
            case EdgeEventType.CALCULATED_FIELD -> new CalculatedFieldId(uuid);
            case EdgeEventType.SECRET -> new SecretId(uuid);
            default -> throw new IllegalArgumentException("EdgeEventType " + String.valueOf((Object)edgeEventType) + " is not supported!");
        };
    }
}

