/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.id;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.UUID;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.UUIDBased;

public class EntityGroupId
extends UUIDBased
implements EntityId {
    private static final long serialVersionUID = 1L;

    @JsonCreator
    public EntityGroupId(@JsonProperty(value="id") UUID id) {
        super(id);
    }

    public static EntityGroupId fromString(String entityGroupId) {
        return new EntityGroupId(UUID.fromString(entityGroupId));
    }

    @Override
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="string", example="ENTITY_GROUP", allowableValues={"ENTITY_GROUP"})
    public EntityType getEntityType() {
        return EntityType.ENTITY_GROUP;
    }
}

