/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.housekeeper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import lombok.Generated;
import lombok.NonNull;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.housekeeper.AlarmsDeletionHousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.AlarmsUnassignHousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.EntitiesCleanupHousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.EntitiesDeletionHousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.common.data.housekeeper.LatestTsDeletionHousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.TenantEntitiesDeletionHousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.TsHistoryDeletionHousekeeperTask;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="taskType", visible=true, include=JsonTypeInfo.As.EXISTING_PROPERTY, defaultImpl=HousekeeperTask.class)
@JsonSubTypes(value={@JsonSubTypes.Type(name="DELETE_TS_HISTORY", value=TsHistoryDeletionHousekeeperTask.class), @JsonSubTypes.Type(name="DELETE_LATEST_TS", value=LatestTsDeletionHousekeeperTask.class), @JsonSubTypes.Type(name="DELETE_TENANT_ENTITIES", value=TenantEntitiesDeletionHousekeeperTask.class), @JsonSubTypes.Type(name="DELETE_ENTITIES", value=EntitiesDeletionHousekeeperTask.class), @JsonSubTypes.Type(name="DELETE_ALARMS", value=AlarmsDeletionHousekeeperTask.class), @JsonSubTypes.Type(name="UNASSIGN_ALARMS", value=AlarmsUnassignHousekeeperTask.class), @JsonSubTypes.Type(name="CLEANUP_ENTITIES", value=EntitiesCleanupHousekeeperTask.class)})
public class HousekeeperTask
implements Serializable {
    private TenantId tenantId;
    private EntityId entityId;
    private HousekeeperTaskType taskType;
    private long ts;

    protected HousekeeperTask(@NonNull TenantId tenantId, @NonNull EntityId entityId, @NonNull HousekeeperTaskType taskType) {
        if (tenantId == null) {
            throw new NullPointerException("tenantId is marked non-null but is null");
        }
        if (entityId == null) {
            throw new NullPointerException("entityId is marked non-null but is null");
        }
        if (taskType == null) {
            throw new NullPointerException("taskType is marked non-null but is null");
        }
        this.tenantId = tenantId;
        this.entityId = entityId;
        this.taskType = taskType;
        this.ts = System.currentTimeMillis();
    }

    public static HousekeeperTask deleteAttributes(TenantId tenantId, EntityId entityId) {
        return new HousekeeperTask(tenantId, entityId, HousekeeperTaskType.DELETE_ATTRIBUTES);
    }

    public static HousekeeperTask deleteTelemetry(TenantId tenantId, EntityId entityId) {
        return new HousekeeperTask(tenantId, entityId, HousekeeperTaskType.DELETE_TELEMETRY);
    }

    public static HousekeeperTask deleteEvents(TenantId tenantId, EntityId entityId) {
        return new HousekeeperTask(tenantId, entityId, HousekeeperTaskType.DELETE_EVENTS);
    }

    public static HousekeeperTask unassignAlarms(User user) {
        return new AlarmsUnassignHousekeeperTask(user);
    }

    public static HousekeeperTask deleteAlarms(TenantId tenantId, EntityId entityId) {
        return new AlarmsDeletionHousekeeperTask(tenantId, entityId);
    }

    public static HousekeeperTask deleteTenantEntities(TenantId tenantId, EntityType entityType) {
        return new TenantEntitiesDeletionHousekeeperTask(tenantId, entityType);
    }

    public static HousekeeperTask deleteCalculatedFields(TenantId tenantId, EntityId entityId) {
        return new HousekeeperTask(tenantId, entityId, HousekeeperTaskType.DELETE_CALCULATED_FIELDS);
    }

    public static HousekeeperTask deleteJobs(TenantId tenantId, EntityId entityId) {
        return new HousekeeperTask(tenantId, entityId, HousekeeperTaskType.DELETE_JOBS);
    }

    @JsonIgnore
    public String getDescription() {
        return this.taskType.getDescription() + " for " + this.entityId.getEntityType().getNormalName().toLowerCase() + " " + String.valueOf(this.entityId.getId());
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public HousekeeperTaskType getTaskType() {
        return this.taskType;
    }

    @Generated
    public long getTs() {
        return this.ts;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setTaskType(HousekeeperTaskType taskType) {
        this.taskType = taskType;
    }

    @Generated
    public void setTs(long ts) {
        this.ts = ts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HousekeeperTask)) {
            return false;
        }
        HousekeeperTask other = (HousekeeperTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        HousekeeperTaskType this$taskType = this.getTaskType();
        HousekeeperTaskType other$taskType = other.getTaskType();
        return !(this$taskType == null ? other$taskType != null : !((Object)((Object)this$taskType)).equals((Object)other$taskType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HousekeeperTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        HousekeeperTaskType $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)((Object)$taskType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HousekeeperTask(tenantId=" + String.valueOf(this.getTenantId()) + ", entityId=" + String.valueOf(this.getEntityId()) + ", taskType=" + String.valueOf((Object)this.getTaskType()) + ", ts=" + this.getTs() + ")";
    }

    @Generated
    protected HousekeeperTask() {
    }
}

