/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.housekeeper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.common.data.id.TenantId;

public class EntitiesDeletionHousekeeperTask
extends HousekeeperTask {
    private EntityType entityType;
    private List<UUID> entities;

    public EntitiesDeletionHousekeeperTask(TenantId tenantId, EntityType entityType, List<UUID> entities) {
        super(tenantId, tenantId, HousekeeperTaskType.DELETE_ENTITIES);
        this.entityType = entityType;
        this.entities = entities;
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return this.entityType.getNormalName().toLowerCase() + "s deletion (" + String.valueOf(this.entities) + ")";
    }

    @Generated
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Generated
    public List<UUID> getEntities() {
        return this.entities;
    }

    @Generated
    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    @Generated
    public void setEntities(List<UUID> entities) {
        this.entities = entities;
    }

    @Override
    @Generated
    public String toString() {
        return "EntitiesDeletionHousekeeperTask(super=" + super.toString() + ", entityType=" + String.valueOf((Object)this.getEntityType()) + ", entities=" + String.valueOf(this.getEntities()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntitiesDeletionHousekeeperTask)) {
            return false;
        }
        EntitiesDeletionHousekeeperTask other = (EntitiesDeletionHousekeeperTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EntityType this$entityType = this.getEntityType();
        EntityType other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !((Object)((Object)this$entityType)).equals((Object)other$entityType)) {
            return false;
        }
        List<UUID> this$entities = this.getEntities();
        List<UUID> other$entities = other.getEntities();
        return !(this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntitiesDeletionHousekeeperTask;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        EntityType $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : ((Object)((Object)$entityType)).hashCode());
        List<UUID> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        return result;
    }

    @Generated
    public EntitiesDeletionHousekeeperTask() {
    }
}

