/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.event.EventFilter;
import org.thingsboard.server.common.data.event.EventType;

@Schema
public class StatisticsEventFilter
implements EventFilter {
    @Schema(description="String value representing the server name, identifier or ip address where the platform is running", example="ip-172-31-24-152")
    protected String server;
    @Schema(description="The minimum number of successfully processed messages", example="25")
    protected Integer minMessagesProcessed;
    @Schema(description="The maximum number of successfully processed messages", example="250")
    protected Integer maxMessagesProcessed;
    @Schema(description="The minimum number of errors occurred during messages processing", example="30")
    protected Integer minErrorsOccurred;
    @Schema(description="The maximum number of errors occurred during messages processing", example="300")
    protected Integer maxErrorsOccurred;

    @Override
    public EventType getEventType() {
        return EventType.STATS;
    }

    @Override
    public boolean isNotEmpty() {
        return !StringUtils.isEmpty(this.server) || this.minMessagesProcessed != null && this.minMessagesProcessed > 0 || this.minErrorsOccurred != null && this.minErrorsOccurred > 0 || this.maxMessagesProcessed != null && this.maxMessagesProcessed > 0 || this.maxErrorsOccurred != null && this.maxErrorsOccurred > 0;
    }

    @Generated
    public StatisticsEventFilter() {
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public Integer getMinMessagesProcessed() {
        return this.minMessagesProcessed;
    }

    @Generated
    public Integer getMaxMessagesProcessed() {
        return this.maxMessagesProcessed;
    }

    @Generated
    public Integer getMinErrorsOccurred() {
        return this.minErrorsOccurred;
    }

    @Generated
    public Integer getMaxErrorsOccurred() {
        return this.maxErrorsOccurred;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setMinMessagesProcessed(Integer minMessagesProcessed) {
        this.minMessagesProcessed = minMessagesProcessed;
    }

    @Generated
    public void setMaxMessagesProcessed(Integer maxMessagesProcessed) {
        this.maxMessagesProcessed = maxMessagesProcessed;
    }

    @Generated
    public void setMinErrorsOccurred(Integer minErrorsOccurred) {
        this.minErrorsOccurred = minErrorsOccurred;
    }

    @Generated
    public void setMaxErrorsOccurred(Integer maxErrorsOccurred) {
        this.maxErrorsOccurred = maxErrorsOccurred;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticsEventFilter)) {
            return false;
        }
        StatisticsEventFilter other = (StatisticsEventFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$minMessagesProcessed = this.getMinMessagesProcessed();
        Integer other$minMessagesProcessed = other.getMinMessagesProcessed();
        if (this$minMessagesProcessed == null ? other$minMessagesProcessed != null : !((Object)this$minMessagesProcessed).equals(other$minMessagesProcessed)) {
            return false;
        }
        Integer this$maxMessagesProcessed = this.getMaxMessagesProcessed();
        Integer other$maxMessagesProcessed = other.getMaxMessagesProcessed();
        if (this$maxMessagesProcessed == null ? other$maxMessagesProcessed != null : !((Object)this$maxMessagesProcessed).equals(other$maxMessagesProcessed)) {
            return false;
        }
        Integer this$minErrorsOccurred = this.getMinErrorsOccurred();
        Integer other$minErrorsOccurred = other.getMinErrorsOccurred();
        if (this$minErrorsOccurred == null ? other$minErrorsOccurred != null : !((Object)this$minErrorsOccurred).equals(other$minErrorsOccurred)) {
            return false;
        }
        Integer this$maxErrorsOccurred = this.getMaxErrorsOccurred();
        Integer other$maxErrorsOccurred = other.getMaxErrorsOccurred();
        if (this$maxErrorsOccurred == null ? other$maxErrorsOccurred != null : !((Object)this$maxErrorsOccurred).equals(other$maxErrorsOccurred)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        return !(this$server == null ? other$server != null : !this$server.equals(other$server));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StatisticsEventFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minMessagesProcessed = this.getMinMessagesProcessed();
        result = result * 59 + ($minMessagesProcessed == null ? 43 : ((Object)$minMessagesProcessed).hashCode());
        Integer $maxMessagesProcessed = this.getMaxMessagesProcessed();
        result = result * 59 + ($maxMessagesProcessed == null ? 43 : ((Object)$maxMessagesProcessed).hashCode());
        Integer $minErrorsOccurred = this.getMinErrorsOccurred();
        result = result * 59 + ($minErrorsOccurred == null ? 43 : ((Object)$minErrorsOccurred).hashCode());
        Integer $maxErrorsOccurred = this.getMaxErrorsOccurred();
        result = result * 59 + ($maxErrorsOccurred == null ? 43 : ((Object)$maxErrorsOccurred).hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StatisticsEventFilter(server=" + this.getServer() + ", minMessagesProcessed=" + this.getMinMessagesProcessed() + ", maxMessagesProcessed=" + this.getMaxMessagesProcessed() + ", minErrorsOccurred=" + this.getMinErrorsOccurred() + ", maxErrorsOccurred=" + this.getMaxErrorsOccurred() + ")";
    }
}

