/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.event.DebugEventFilter;
import org.thingsboard.server.common.data.event.EventType;

@Schema
public class RuleNodeDebugEventFilter
extends DebugEventFilter {
    @Schema(description="String value representing msg direction type (incoming to entity or outcoming from entity)", allowableValues={"IN", "OUT"})
    protected String msgDirectionType;
    @Schema(description="String value representing the entity id in the event body (originator of the message)", example="de9d54a0-2b7a-11ec-a3cc-23386423d98f")
    protected String entityId;
    @Schema(description="String value representing the entity type", allowableValues={"DEVICE"})
    protected String entityType;
    @Schema(description="String value representing the message id in the rule engine", example="de9d54a0-2b7a-11ec-a3cc-23386423d98f")
    protected String msgId;
    @Schema(description="String value representing the message type", example="POST_TELEMETRY_REQUEST")
    protected String msgType;
    @Schema(description="String value representing the type of message routing", example="Success")
    protected String relationType;
    @Schema(description="The case insensitive 'contains' filter based on data (key and value) for the message.", example="humidity")
    protected String dataSearch;
    @Schema(description="The case insensitive 'contains' filter based on metadata (key and value) for the message.", example="deviceName")
    protected String metadataSearch;

    @Override
    public EventType getEventType() {
        return EventType.DEBUG_RULE_NODE;
    }

    @Override
    public boolean isNotEmpty() {
        return super.isNotEmpty() || !StringUtils.isEmpty(this.msgDirectionType) || !StringUtils.isEmpty(this.entityId) || !StringUtils.isEmpty(this.entityType) || !StringUtils.isEmpty(this.msgId) || !StringUtils.isEmpty(this.msgType) || !StringUtils.isEmpty(this.relationType) || !StringUtils.isEmpty(this.dataSearch) || !StringUtils.isEmpty(this.metadataSearch);
    }

    @Generated
    public RuleNodeDebugEventFilter() {
    }

    @Generated
    public String getMsgDirectionType() {
        return this.msgDirectionType;
    }

    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getEntityType() {
        return this.entityType;
    }

    @Generated
    public String getMsgId() {
        return this.msgId;
    }

    @Generated
    public String getMsgType() {
        return this.msgType;
    }

    @Generated
    public String getRelationType() {
        return this.relationType;
    }

    @Generated
    public String getDataSearch() {
        return this.dataSearch;
    }

    @Generated
    public String getMetadataSearch() {
        return this.metadataSearch;
    }

    @Generated
    public void setMsgDirectionType(String msgDirectionType) {
        this.msgDirectionType = msgDirectionType;
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    @Generated
    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    @Generated
    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    @Generated
    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    @Generated
    public void setDataSearch(String dataSearch) {
        this.dataSearch = dataSearch;
    }

    @Generated
    public void setMetadataSearch(String metadataSearch) {
        this.metadataSearch = metadataSearch;
    }

    @Override
    @Generated
    public String toString() {
        return "RuleNodeDebugEventFilter(msgDirectionType=" + this.getMsgDirectionType() + ", entityId=" + this.getEntityId() + ", entityType=" + this.getEntityType() + ", msgId=" + this.getMsgId() + ", msgType=" + this.getMsgType() + ", relationType=" + this.getRelationType() + ", dataSearch=" + this.getDataSearch() + ", metadataSearch=" + this.getMetadataSearch() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleNodeDebugEventFilter)) {
            return false;
        }
        RuleNodeDebugEventFilter other = (RuleNodeDebugEventFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$msgDirectionType = this.getMsgDirectionType();
        String other$msgDirectionType = other.getMsgDirectionType();
        if (this$msgDirectionType == null ? other$msgDirectionType != null : !this$msgDirectionType.equals(other$msgDirectionType)) {
            return false;
        }
        String this$entityId = this.getEntityId();
        String other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        String this$entityType = this.getEntityType();
        String other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        String this$msgId = this.getMsgId();
        String other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !this$msgId.equals(other$msgId)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$relationType = this.getRelationType();
        String other$relationType = other.getRelationType();
        if (this$relationType == null ? other$relationType != null : !this$relationType.equals(other$relationType)) {
            return false;
        }
        String this$dataSearch = this.getDataSearch();
        String other$dataSearch = other.getDataSearch();
        if (this$dataSearch == null ? other$dataSearch != null : !this$dataSearch.equals(other$dataSearch)) {
            return false;
        }
        String this$metadataSearch = this.getMetadataSearch();
        String other$metadataSearch = other.getMetadataSearch();
        return !(this$metadataSearch == null ? other$metadataSearch != null : !this$metadataSearch.equals(other$metadataSearch));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RuleNodeDebugEventFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $msgDirectionType = this.getMsgDirectionType();
        result = result * 59 + ($msgDirectionType == null ? 43 : $msgDirectionType.hashCode());
        String $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        String $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        String $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : $msgId.hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $relationType = this.getRelationType();
        result = result * 59 + ($relationType == null ? 43 : $relationType.hashCode());
        String $dataSearch = this.getDataSearch();
        result = result * 59 + ($dataSearch == null ? 43 : $dataSearch.hashCode());
        String $metadataSearch = this.getMetadataSearch();
        result = result * 59 + ($metadataSearch == null ? 43 : $metadataSearch.hashCode());
        return result;
    }
}

