/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;

public class RuleNodeDebugEvent
extends Event {
    private static final long serialVersionUID = -6575797430064573984L;
    private final String eventType;
    private final EntityId eventEntity;
    private final UUID msgId;
    private final String msgType;
    private final String dataType;
    private final String relationType;
    private String data;
    private String metadata;
    private String error;

    private RuleNodeDebugEvent(TenantId tenantId, UUID entityId, String serviceId, UUID id, long ts, String eventType, EntityId eventEntity, UUID msgId, String msgType, String dataType, String relationType, String data, String metadata, String error) {
        super(tenantId, entityId, serviceId, id, ts);
        this.eventType = eventType;
        this.eventEntity = eventEntity;
        this.msgId = msgId;
        this.msgType = msgType;
        this.dataType = dataType;
        this.relationType = relationType;
        this.data = data;
        this.metadata = metadata;
        this.error = error;
    }

    @Override
    public EventType getType() {
        return EventType.DEBUG_RULE_NODE;
    }

    @Override
    public EventInfo toInfo(EntityType entityType) {
        EventInfo eventInfo = super.toInfo(entityType);
        ObjectNode json = (ObjectNode)eventInfo.getBody();
        json.put("type", this.eventType);
        if (this.eventEntity != null) {
            json.put("entityId", this.eventEntity.getId().toString()).put("entityType", this.eventEntity.getEntityType().name());
        }
        if (this.msgId != null) {
            json.put("msgId", this.msgId.toString());
        }
        RuleNodeDebugEvent.putNotNull(json, "msgType", this.msgType);
        RuleNodeDebugEvent.putNotNull(json, "dataType", this.dataType);
        RuleNodeDebugEvent.putNotNull(json, "relationType", this.relationType);
        RuleNodeDebugEvent.putNotNull(json, "data", this.data);
        RuleNodeDebugEvent.putNotNull(json, "metadata", this.metadata);
        RuleNodeDebugEvent.putNotNull(json, "error", this.error);
        return eventInfo;
    }

    @Generated
    public static RuleNodeDebugEventBuilder builder() {
        return new RuleNodeDebugEventBuilder();
    }

    @Override
    @Generated
    public String toString() {
        return "RuleNodeDebugEvent(eventType=" + this.getEventType() + ", eventEntity=" + String.valueOf(this.getEventEntity()) + ", msgId=" + String.valueOf(this.getMsgId()) + ", msgType=" + this.getMsgType() + ", dataType=" + this.getDataType() + ", relationType=" + this.getRelationType() + ", data=" + this.getData() + ", metadata=" + this.getMetadata() + ", error=" + this.getError() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleNodeDebugEvent)) {
            return false;
        }
        RuleNodeDebugEvent other = (RuleNodeDebugEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        EntityId this$eventEntity = this.getEventEntity();
        EntityId other$eventEntity = other.getEventEntity();
        if (this$eventEntity == null ? other$eventEntity != null : !this$eventEntity.equals(other$eventEntity)) {
            return false;
        }
        UUID this$msgId = this.getMsgId();
        UUID other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !((Object)this$msgId).equals(other$msgId)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$relationType = this.getRelationType();
        String other$relationType = other.getRelationType();
        if (this$relationType == null ? other$relationType != null : !this$relationType.equals(other$relationType)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$metadata = this.getMetadata();
        String other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RuleNodeDebugEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        EntityId $eventEntity = this.getEventEntity();
        result = result * 59 + ($eventEntity == null ? 43 : $eventEntity.hashCode());
        UUID $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : ((Object)$msgId).hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $relationType = this.getRelationType();
        result = result * 59 + ($relationType == null ? 43 : $relationType.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    @Generated
    public String getEventType() {
        return this.eventType;
    }

    @Generated
    public EntityId getEventEntity() {
        return this.eventEntity;
    }

    @Generated
    public UUID getMsgId() {
        return this.msgId;
    }

    @Generated
    public String getMsgType() {
        return this.msgType;
    }

    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Generated
    public String getRelationType() {
        return this.relationType;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public void setData(String data) {
        this.data = data;
    }

    @Generated
    public String getMetadata() {
        return this.metadata;
    }

    @Generated
    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public static class RuleNodeDebugEventBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private UUID entityId;
        @Generated
        private String serviceId;
        @Generated
        private UUID id;
        @Generated
        private long ts;
        @Generated
        private String eventType;
        @Generated
        private EntityId eventEntity;
        @Generated
        private UUID msgId;
        @Generated
        private String msgType;
        @Generated
        private String dataType;
        @Generated
        private String relationType;
        @Generated
        private String data;
        @Generated
        private String metadata;
        @Generated
        private String error;

        @Generated
        RuleNodeDebugEventBuilder() {
        }

        @Generated
        public RuleNodeDebugEventBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public RuleNodeDebugEventBuilder entityId(UUID entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public RuleNodeDebugEventBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Generated
        public RuleNodeDebugEventBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        @Generated
        public RuleNodeDebugEventBuilder ts(long ts) {
            this.ts = ts;
            return this;
        }

        @Generated
        public RuleNodeDebugEventBuilder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Generated
        public RuleNodeDebugEventBuilder eventEntity(EntityId eventEntity) {
            this.eventEntity = eventEntity;
            return this;
        }

        @Generated
        public RuleNodeDebugEventBuilder msgId(UUID msgId) {
            this.msgId = msgId;
            return this;
        }

        @Generated
        public RuleNodeDebugEventBuilder msgType(String msgType) {
            this.msgType = msgType;
            return this;
        }

        @Generated
        public RuleNodeDebugEventBuilder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Generated
        public RuleNodeDebugEventBuilder relationType(String relationType) {
            this.relationType = relationType;
            return this;
        }

        @Generated
        public RuleNodeDebugEventBuilder data(String data) {
            this.data = data;
            return this;
        }

        @Generated
        public RuleNodeDebugEventBuilder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public RuleNodeDebugEventBuilder error(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public RuleNodeDebugEvent build() {
            return new RuleNodeDebugEvent(this.tenantId, this.entityId, this.serviceId, this.id, this.ts, this.eventType, this.eventEntity, this.msgId, this.msgType, this.dataType, this.relationType, this.data, this.metadata, this.error);
        }

        @Generated
        public String toString() {
            return "RuleNodeDebugEvent.RuleNodeDebugEventBuilder(tenantId=" + String.valueOf(this.tenantId) + ", entityId=" + String.valueOf(this.entityId) + ", serviceId=" + this.serviceId + ", id=" + String.valueOf(this.id) + ", ts=" + this.ts + ", eventType=" + this.eventType + ", eventEntity=" + String.valueOf(this.eventEntity) + ", msgId=" + String.valueOf(this.msgId) + ", msgType=" + this.msgType + ", dataType=" + this.dataType + ", relationType=" + this.relationType + ", data=" + this.data + ", metadata=" + this.metadata + ", error=" + this.error + ")";
        }
    }
}

