/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.event.EventFilter;
import org.thingsboard.server.common.data.event.EventType;

@Schema
public class RawDataEventFilter
implements EventFilter {
    @Schema(description="String value representing the server name, identifier or ip address where the platform is running", example="ip-172-31-24-152")
    protected String server;
    @Schema(description="String value representing the uuid", example="STARTED")
    protected String uuid;
    @Schema(description="String value representing the message type")
    protected String messageType;
    @Schema(description="String value representing the message")
    protected String message;

    @Override
    public EventType getEventType() {
        return EventType.RAW_DATA;
    }

    @Override
    public boolean isNotEmpty() {
        return !StringUtils.isEmpty(this.server) || !StringUtils.isEmpty(this.uuid) || !StringUtils.isEmpty(this.messageType) || !StringUtils.isEmpty(this.message);
    }

    @Generated
    public RawDataEventFilter() {
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getMessageType() {
        return this.messageType;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawDataEventFilter)) {
            return false;
        }
        RawDataEventFilter other = (RawDataEventFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$messageType = this.getMessageType();
        String other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RawDataEventFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RawDataEventFilter(server=" + this.getServer() + ", uuid=" + this.getUuid() + ", messageType=" + this.getMessageType() + ", message=" + this.getMessage() + ")";
    }
}

