/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.id.TenantId;

public class IntegrationDebugEvent
extends Event {
    private final String eventType;
    private final String messageType;
    private String message;
    private String status;
    private String error;

    public IntegrationDebugEvent(TenantId tenantId, UUID entityId, String serviceId, UUID id, long ts, String eventType, String messageType, String message, String status, String error) {
        super(tenantId, entityId, serviceId, id, ts);
        this.eventType = eventType;
        this.messageType = messageType;
        this.message = message;
        this.status = status;
        this.error = error;
    }

    @Override
    public EventType getType() {
        return EventType.DEBUG_INTEGRATION;
    }

    @Override
    public EventInfo toInfo(EntityType entityType) {
        EventInfo eventInfo = super.toInfo(entityType);
        ObjectNode json = (ObjectNode)eventInfo.getBody();
        json.put("type", this.eventType);
        IntegrationDebugEvent.putNotNull(json, "messageType", this.messageType);
        IntegrationDebugEvent.putNotNull(json, "message", this.message);
        IntegrationDebugEvent.putNotNull(json, "status", this.status);
        IntegrationDebugEvent.putNotNull(json, "error", this.error);
        return eventInfo;
    }

    @Generated
    public static IntegrationDebugEventBuilder builder() {
        return new IntegrationDebugEventBuilder();
    }

    @Override
    @Generated
    public String toString() {
        return "IntegrationDebugEvent(eventType=" + this.getEventType() + ", messageType=" + this.getMessageType() + ", message=" + this.getMessage() + ", status=" + this.getStatus() + ", error=" + this.getError() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegrationDebugEvent)) {
            return false;
        }
        IntegrationDebugEvent other = (IntegrationDebugEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$messageType = this.getMessageType();
        String other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IntegrationDebugEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    @Generated
    public String getEventType() {
        return this.eventType;
    }

    @Generated
    public String getMessageType() {
        return this.messageType;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public static class IntegrationDebugEventBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private UUID entityId;
        @Generated
        private String serviceId;
        @Generated
        private UUID id;
        @Generated
        private long ts;
        @Generated
        private String eventType;
        @Generated
        private String messageType;
        @Generated
        private String message;
        @Generated
        private String status;
        @Generated
        private String error;

        @Generated
        IntegrationDebugEventBuilder() {
        }

        @Generated
        public IntegrationDebugEventBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public IntegrationDebugEventBuilder entityId(UUID entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public IntegrationDebugEventBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Generated
        public IntegrationDebugEventBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        @Generated
        public IntegrationDebugEventBuilder ts(long ts) {
            this.ts = ts;
            return this;
        }

        @Generated
        public IntegrationDebugEventBuilder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Generated
        public IntegrationDebugEventBuilder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Generated
        public IntegrationDebugEventBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public IntegrationDebugEventBuilder status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public IntegrationDebugEventBuilder error(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public IntegrationDebugEvent build() {
            return new IntegrationDebugEvent(this.tenantId, this.entityId, this.serviceId, this.id, this.ts, this.eventType, this.messageType, this.message, this.status, this.error);
        }

        @Generated
        public String toString() {
            return "IntegrationDebugEvent.IntegrationDebugEventBuilder(tenantId=" + String.valueOf(this.tenantId) + ", entityId=" + String.valueOf(this.entityId) + ", serviceId=" + this.serviceId + ", id=" + String.valueOf(this.id) + ", ts=" + this.ts + ", eventType=" + this.eventType + ", messageType=" + this.messageType + ", message=" + this.message + ", status=" + this.status + ", error=" + this.error + ")";
        }
    }
}

