/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.EventId;
import org.thingsboard.server.common.data.id.TenantId;

public abstract class Event
extends BaseData<EventId> {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected TenantId tenantId;
    protected UUID entityId;
    protected final String serviceId;

    public Event(TenantId tenantId, UUID entityId, String serviceId, UUID id, long ts) {
        if (id != null) {
            this.id = new EventId(id);
        }
        this.tenantId = tenantId != null ? tenantId : TenantId.SYS_TENANT_ID;
        this.entityId = entityId;
        this.serviceId = serviceId;
        this.createdTime = ts;
    }

    public abstract EventType getType();

    public EventInfo toInfo(EntityType entityType) {
        EventInfo eventInfo = new EventInfo();
        eventInfo.setTenantId(this.tenantId);
        eventInfo.setEntityId(EntityIdFactory.getByTypeAndUuid(entityType, this.entityId));
        eventInfo.setType(this.getType().getOldName());
        eventInfo.setId((EventId)this.id);
        eventInfo.setUid(((EventId)this.id).toString());
        eventInfo.setCreatedTime(this.createdTime);
        eventInfo.setBody((JsonNode)OBJECT_MAPPER.createObjectNode().put("server", this.getServiceId()));
        return eventInfo;
    }

    protected static void putNotNull(ObjectNode json, String key, String value) {
        if (value != null) {
            json.put(key, value);
        }
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public UUID getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setEntityId(UUID entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String toString() {
        return "Event(tenantId=" + String.valueOf(this.getTenantId()) + ", entityId=" + String.valueOf(this.getEntityId()) + ", serviceId=" + this.getServiceId() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$entityId = this.getEntityId();
        UUID other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !((Object)this$entityId).equals(other$entityId)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        return !(this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : ((Object)$entityId).hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        return result;
    }
}

