/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.event.DebugEventFilter;
import org.thingsboard.server.common.data.event.EventType;

@Schema
public class CalculatedFieldDebugEventFilter
extends DebugEventFilter {
    @Schema(description="String value representing the entity id in the event body", example="57b6bafe-d600-423c-9267-fe31e5218986")
    protected String entityId;
    @Schema(description="String value representing the entity type", allowableValues={"DEVICE"})
    protected String entityType;
    @Schema(description="String value representing the message id in the rule engine", example="dcf44612-2ce4-4e5d-b462-ebb9c5628228")
    protected String msgId;
    @Schema(description="String value representing the message type", example="POST_TELEMETRY_REQUEST")
    protected String msgType;
    @Schema(description="String value representing the arguments that were used in the calculation performed", example="{\"x\":{\"ts\":1739432016629,\"value\":20},\"y\":{\"ts\":1739429717656,\"value\":12}}")
    protected String arguments;
    @Schema(description="String value representing the result of a calculation", example="{\"x + y\":32}")
    protected String result;

    @Override
    public EventType getEventType() {
        return EventType.DEBUG_CALCULATED_FIELD;
    }

    @Override
    public boolean isNotEmpty() {
        return super.isNotEmpty() || !StringUtils.isEmpty(this.entityId) || !StringUtils.isEmpty(this.entityType) || !StringUtils.isEmpty(this.msgId) || !StringUtils.isEmpty(this.msgType) || !StringUtils.isEmpty(this.arguments) || !StringUtils.isEmpty(this.result);
    }

    @Generated
    public CalculatedFieldDebugEventFilter() {
    }

    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getEntityType() {
        return this.entityType;
    }

    @Generated
    public String getMsgId() {
        return this.msgId;
    }

    @Generated
    public String getMsgType() {
        return this.msgType;
    }

    @Generated
    public String getArguments() {
        return this.arguments;
    }

    @Generated
    public String getResult() {
        return this.result;
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    @Generated
    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    @Generated
    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    @Generated
    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    @Generated
    public void setResult(String result) {
        this.result = result;
    }

    @Override
    @Generated
    public String toString() {
        return "CalculatedFieldDebugEventFilter(entityId=" + this.getEntityId() + ", entityType=" + this.getEntityType() + ", msgId=" + this.getMsgId() + ", msgType=" + this.getMsgType() + ", arguments=" + this.getArguments() + ", result=" + this.getResult() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculatedFieldDebugEventFilter)) {
            return false;
        }
        CalculatedFieldDebugEventFilter other = (CalculatedFieldDebugEventFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$entityId = this.getEntityId();
        String other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        String this$entityType = this.getEntityType();
        String other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        String this$msgId = this.getMsgId();
        String other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !this$msgId.equals(other$msgId)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$arguments = this.getArguments();
        String other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !this$arguments.equals(other$arguments)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculatedFieldDebugEventFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        String $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        String $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : $msgId.hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : $arguments.hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }
}

