/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;

public class CalculatedFieldDebugEvent
extends Event {
    private static final long serialVersionUID = -7091690784759639853L;
    private final CalculatedFieldId calculatedFieldId;
    private final EntityId eventEntity;
    private final UUID msgId;
    private final String msgType;
    private String arguments;
    private String result;
    private String error;

    private CalculatedFieldDebugEvent(TenantId tenantId, UUID entityId, String serviceId, UUID id, long ts, CalculatedFieldId calculatedFieldId, EntityId eventEntity, UUID msgId, String msgType, String arguments, String result, String error) {
        super(tenantId, entityId, serviceId, id, ts);
        this.calculatedFieldId = calculatedFieldId;
        this.eventEntity = eventEntity;
        this.msgId = msgId;
        this.msgType = msgType;
        this.arguments = arguments;
        this.result = result;
        this.error = error;
    }

    @Override
    public EventType getType() {
        return EventType.DEBUG_CALCULATED_FIELD;
    }

    @Override
    public EventInfo toInfo(EntityType entityType) {
        EventInfo eventInfo = super.toInfo(entityType);
        ObjectNode json = (ObjectNode)eventInfo.getBody();
        json.put("calculatedFieldId", this.calculatedFieldId.toString());
        if (this.eventEntity != null) {
            json.put("entityId", this.eventEntity.getId().toString()).put("entityType", this.eventEntity.getEntityType().name());
        }
        if (this.msgId != null) {
            json.put("msgId", this.msgId.toString());
        }
        CalculatedFieldDebugEvent.putNotNull(json, "msgType", this.msgType);
        CalculatedFieldDebugEvent.putNotNull(json, "arguments", this.arguments);
        CalculatedFieldDebugEvent.putNotNull(json, "result", this.result);
        CalculatedFieldDebugEvent.putNotNull(json, "error", this.error);
        return eventInfo;
    }

    @Generated
    public static CalculatedFieldDebugEventBuilder builder() {
        return new CalculatedFieldDebugEventBuilder();
    }

    @Override
    @Generated
    public String toString() {
        return "CalculatedFieldDebugEvent(calculatedFieldId=" + String.valueOf(this.getCalculatedFieldId()) + ", eventEntity=" + String.valueOf(this.getEventEntity()) + ", msgId=" + String.valueOf(this.getMsgId()) + ", msgType=" + this.getMsgType() + ", arguments=" + this.getArguments() + ", result=" + this.getResult() + ", error=" + this.getError() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculatedFieldDebugEvent)) {
            return false;
        }
        CalculatedFieldDebugEvent other = (CalculatedFieldDebugEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CalculatedFieldId this$calculatedFieldId = this.getCalculatedFieldId();
        CalculatedFieldId other$calculatedFieldId = other.getCalculatedFieldId();
        if (this$calculatedFieldId == null ? other$calculatedFieldId != null : !((Object)this$calculatedFieldId).equals(other$calculatedFieldId)) {
            return false;
        }
        EntityId this$eventEntity = this.getEventEntity();
        EntityId other$eventEntity = other.getEventEntity();
        if (this$eventEntity == null ? other$eventEntity != null : !this$eventEntity.equals(other$eventEntity)) {
            return false;
        }
        UUID this$msgId = this.getMsgId();
        UUID other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !((Object)this$msgId).equals(other$msgId)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$arguments = this.getArguments();
        String other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !this$arguments.equals(other$arguments)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculatedFieldDebugEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CalculatedFieldId $calculatedFieldId = this.getCalculatedFieldId();
        result = result * 59 + ($calculatedFieldId == null ? 43 : ((Object)$calculatedFieldId).hashCode());
        EntityId $eventEntity = this.getEventEntity();
        result = result * 59 + ($eventEntity == null ? 43 : $eventEntity.hashCode());
        UUID $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : ((Object)$msgId).hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : $arguments.hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    @Generated
    public CalculatedFieldId getCalculatedFieldId() {
        return this.calculatedFieldId;
    }

    @Generated
    public EntityId getEventEntity() {
        return this.eventEntity;
    }

    @Generated
    public UUID getMsgId() {
        return this.msgId;
    }

    @Generated
    public String getMsgType() {
        return this.msgType;
    }

    @Generated
    public String getArguments() {
        return this.arguments;
    }

    @Generated
    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    @Generated
    public String getResult() {
        return this.result;
    }

    @Generated
    public void setResult(String result) {
        this.result = result;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public static class CalculatedFieldDebugEventBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private UUID entityId;
        @Generated
        private String serviceId;
        @Generated
        private UUID id;
        @Generated
        private long ts;
        @Generated
        private CalculatedFieldId calculatedFieldId;
        @Generated
        private EntityId eventEntity;
        @Generated
        private UUID msgId;
        @Generated
        private String msgType;
        @Generated
        private String arguments;
        @Generated
        private String result;
        @Generated
        private String error;

        @Generated
        CalculatedFieldDebugEventBuilder() {
        }

        @Generated
        public CalculatedFieldDebugEventBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public CalculatedFieldDebugEventBuilder entityId(UUID entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public CalculatedFieldDebugEventBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Generated
        public CalculatedFieldDebugEventBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        @Generated
        public CalculatedFieldDebugEventBuilder ts(long ts) {
            this.ts = ts;
            return this;
        }

        @Generated
        public CalculatedFieldDebugEventBuilder calculatedFieldId(CalculatedFieldId calculatedFieldId) {
            this.calculatedFieldId = calculatedFieldId;
            return this;
        }

        @Generated
        public CalculatedFieldDebugEventBuilder eventEntity(EntityId eventEntity) {
            this.eventEntity = eventEntity;
            return this;
        }

        @Generated
        public CalculatedFieldDebugEventBuilder msgId(UUID msgId) {
            this.msgId = msgId;
            return this;
        }

        @Generated
        public CalculatedFieldDebugEventBuilder msgType(String msgType) {
            this.msgType = msgType;
            return this;
        }

        @Generated
        public CalculatedFieldDebugEventBuilder arguments(String arguments) {
            this.arguments = arguments;
            return this;
        }

        @Generated
        public CalculatedFieldDebugEventBuilder result(String result) {
            this.result = result;
            return this;
        }

        @Generated
        public CalculatedFieldDebugEventBuilder error(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public CalculatedFieldDebugEvent build() {
            return new CalculatedFieldDebugEvent(this.tenantId, this.entityId, this.serviceId, this.id, this.ts, this.calculatedFieldId, this.eventEntity, this.msgId, this.msgType, this.arguments, this.result, this.error);
        }

        @Generated
        public String toString() {
            return "CalculatedFieldDebugEvent.CalculatedFieldDebugEventBuilder(tenantId=" + String.valueOf(this.tenantId) + ", entityId=" + String.valueOf(this.entityId) + ", serviceId=" + this.serviceId + ", id=" + String.valueOf(this.id) + ", ts=" + this.ts + ", calculatedFieldId=" + String.valueOf(this.calculatedFieldId) + ", eventEntity=" + String.valueOf(this.eventEntity) + ", msgId=" + String.valueOf(this.msgId) + ", msgType=" + this.msgType + ", arguments=" + this.arguments + ", result=" + this.result + ", error=" + this.error + ")";
        }
    }
}

