/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.entityview;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.RelationEntityTypeFilter;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;

@Schema
public class EntityViewSearchQuery {
    @Schema(description="Main search parameters.")
    private RelationsSearchParameters parameters;
    @Schema(description="Type of the relation between root entity and device (e.g. 'Contains' or 'Manages').")
    private String relationType;
    @Schema(description="Array of entity view types to filter the related entities (e.g. 'Temperature Sensor', 'Smoke Sensor').")
    private List<String> entityViewTypes;

    public EntityRelationsQuery toEntitySearchQuery() {
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(this.parameters);
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter(this.relationType == null ? "Contains" : this.relationType, Collections.singletonList(EntityType.ENTITY_VIEW))));
        return query;
    }

    @Generated
    public EntityViewSearchQuery() {
    }

    @Generated
    public RelationsSearchParameters getParameters() {
        return this.parameters;
    }

    @Generated
    public String getRelationType() {
        return this.relationType;
    }

    @Generated
    public List<String> getEntityViewTypes() {
        return this.entityViewTypes;
    }

    @Generated
    public void setParameters(RelationsSearchParameters parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    @Generated
    public void setEntityViewTypes(List<String> entityViewTypes) {
        this.entityViewTypes = entityViewTypes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityViewSearchQuery)) {
            return false;
        }
        EntityViewSearchQuery other = (EntityViewSearchQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RelationsSearchParameters this$parameters = this.getParameters();
        RelationsSearchParameters other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$relationType = this.getRelationType();
        String other$relationType = other.getRelationType();
        if (this$relationType == null ? other$relationType != null : !this$relationType.equals(other$relationType)) {
            return false;
        }
        List<String> this$entityViewTypes = this.getEntityViewTypes();
        List<String> other$entityViewTypes = other.getEntityViewTypes();
        return !(this$entityViewTypes == null ? other$entityViewTypes != null : !((Object)this$entityViewTypes).equals(other$entityViewTypes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityViewSearchQuery;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelationsSearchParameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $relationType = this.getRelationType();
        result = result * 59 + ($relationType == null ? 43 : $relationType.hashCode());
        List<String> $entityViewTypes = this.getEntityViewTypes();
        result = result * 59 + ($entityViewTypes == null ? 43 : ((Object)$entityViewTypes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntityViewSearchQuery(parameters=" + String.valueOf(this.getParameters()) + ", relationType=" + this.getRelationType() + ", entityViewTypes=" + String.valueOf(this.getEntityViewTypes()) + ")";
    }
}

