/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.encryptionkey;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.EncryptionKeyId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class EncryptionKey
extends BaseData<EncryptionKeyId>
implements HasTenantId {
    @Schema(description="JSON object with Tenant Id. Tenant Id of the secret cannot be changed.", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @NoXss
    @NotBlank
    @Length(fieldName="password")
    @Schema(description="Encryption key password", requiredMode=Schema.RequiredMode.REQUIRED, example="Password")
    private String password;
    @NoXss
    @NotBlank
    @Length(fieldName="salt")
    @Schema(description="Encryption key salt", requiredMode=Schema.RequiredMode.REQUIRED, example="Salt")
    private String salt;

    public EncryptionKey() {
    }

    public EncryptionKey(EncryptionKeyId id) {
        super(id);
    }

    public EncryptionKey(EncryptionKey encryptionKey) {
        super(encryptionKey);
        this.tenantId = encryptionKey.getTenantId();
        this.password = encryptionKey.getPassword();
        this.salt = encryptionKey.getSalt();
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getSalt() {
        return this.salt;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setSalt(String salt) {
        this.salt = salt;
    }

    @Override
    @Generated
    public String toString() {
        return "EncryptionKey(tenantId=" + String.valueOf(this.getTenantId()) + ", password=" + this.getPassword() + ", salt=" + this.getSalt() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptionKey)) {
            return false;
        }
        EncryptionKey other = (EncryptionKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$salt = this.getSalt();
        String other$salt = other.getSalt();
        return !(this$salt == null ? other$salt != null : !this$salt.equals(other$salt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EncryptionKey;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $salt = this.getSalt();
        result = result * 59 + ($salt == null ? 43 : $salt.hashCode());
        return result;
    }
}

