/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.edqs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ObjectType;
import org.thingsboard.server.common.data.edqs.EdqsObject;
import org.thingsboard.server.common.data.edqs.EdqsObjectKey;
import org.thingsboard.server.common.data.edqs.fields.EntityFields;
import org.thingsboard.server.common.data.edqs.fields.EntityIdFields;

public class Entity
implements EdqsObject {
    private EntityType type;
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    private EntityFields fields;

    public Entity(EntityType type) {
        this.type = type;
    }

    public Entity(EntityType type, EntityFields fields) {
        this.type = type;
        this.fields = fields;
    }

    public Entity(EntityType entityType, UUID id, long version) {
        this.type = entityType;
        this.fields = new EntityIdFields(id, version);
    }

    @Override
    public String stringKey() {
        return "e_" + this.fields.getId().toString();
    }

    @Override
    public Long version() {
        return this.fields.getVersion();
    }

    @Override
    public ObjectType type() {
        return ObjectType.fromEntityType(this.type);
    }

    @Generated
    public EntityType getType() {
        return this.type;
    }

    @Generated
    public EntityFields getFields() {
        return this.fields;
    }

    @Generated
    public void setType(EntityType type) {
        this.type = type;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    @Generated
    public void setFields(EntityFields fields) {
        this.fields = fields;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityType this$type = this.getType();
        EntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        EntityFields this$fields = this.getFields();
        EntityFields other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !this$fields.equals(other$fields));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Entity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        EntityFields $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Entity(type=" + String.valueOf((Object)this.getType()) + ", fields=" + String.valueOf(this.getFields()) + ")";
    }

    @Generated
    public Entity() {
    }

    public record Key(UUID id) implements EdqsObjectKey
    {
    }
}

