/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.edqs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EdqsState {
    private Boolean edqsReady;
    private EdqsSyncStatus syncStatus;
    private EdqsApiMode apiMode;

    public boolean updateEdqsReady(boolean ready) {
        boolean changed = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.edqsReady, (boolean)false) != ready;
        this.edqsReady = ready;
        return changed;
    }

    @JsonIgnore
    public boolean isApiReady() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)this.edqsReady, (boolean)false) && this.syncStatus == EdqsSyncStatus.FINISHED;
    }

    @JsonIgnore
    public boolean isApiEnabled() {
        return this.apiMode != null && (this.apiMode == EdqsApiMode.ENABLED || this.apiMode == EdqsApiMode.AUTO_ENABLED);
    }

    public String toString() {
        return "[EDQS ready: " + this.edqsReady + ", sync status: " + String.valueOf((Object)this.syncStatus) + ", API mode: " + String.valueOf((Object)this.apiMode) + "]";
    }

    @Generated
    public Boolean getEdqsReady() {
        return this.edqsReady;
    }

    @Generated
    public EdqsSyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    @Generated
    public EdqsApiMode getApiMode() {
        return this.apiMode;
    }

    @Generated
    public EdqsState() {
    }

    @Generated
    public void setSyncStatus(EdqsSyncStatus syncStatus) {
        this.syncStatus = syncStatus;
    }

    @Generated
    public void setApiMode(EdqsApiMode apiMode) {
        this.apiMode = apiMode;
    }

    public static enum EdqsSyncStatus {
        REQUESTED,
        STARTED,
        FINISHED,
        FAILED;

    }

    public static enum EdqsApiMode {
        ENABLED,
        AUTO_ENABLED,
        DISABLED,
        AUTO_DISABLED;

    }
}

