/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.edge;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.RelationEntityTypeFilter;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;

public class EdgeSearchQuery {
    @Schema(description="Main search parameters.")
    private RelationsSearchParameters parameters;
    @Schema(description="Type of the relation between root entity and edge (e.g. 'Contains' or 'Manages').")
    private String relationType;
    @Schema(description="Array of edge types to filter the related entities (e.g. 'Silos', 'Stores').")
    private List<String> edgeTypes;

    public EntityRelationsQuery toEntitySearchQuery() {
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(this.parameters);
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter(this.relationType == null ? "Contains" : this.relationType, Collections.singletonList(EntityType.EDGE))));
        return query;
    }

    @Generated
    public EdgeSearchQuery() {
    }

    @Generated
    public RelationsSearchParameters getParameters() {
        return this.parameters;
    }

    @Generated
    public String getRelationType() {
        return this.relationType;
    }

    @Generated
    public List<String> getEdgeTypes() {
        return this.edgeTypes;
    }

    @Generated
    public void setParameters(RelationsSearchParameters parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    @Generated
    public void setEdgeTypes(List<String> edgeTypes) {
        this.edgeTypes = edgeTypes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdgeSearchQuery)) {
            return false;
        }
        EdgeSearchQuery other = (EdgeSearchQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RelationsSearchParameters this$parameters = this.getParameters();
        RelationsSearchParameters other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$relationType = this.getRelationType();
        String other$relationType = other.getRelationType();
        if (this$relationType == null ? other$relationType != null : !this$relationType.equals(other$relationType)) {
            return false;
        }
        List<String> this$edgeTypes = this.getEdgeTypes();
        List<String> other$edgeTypes = other.getEdgeTypes();
        return !(this$edgeTypes == null ? other$edgeTypes != null : !((Object)this$edgeTypes).equals(other$edgeTypes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EdgeSearchQuery;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelationsSearchParameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $relationType = this.getRelationType();
        result = result * 59 + ($relationType == null ? 43 : $relationType.hashCode());
        List<String> $edgeTypes = this.getEdgeTypes();
        result = result * 59 + ($edgeTypes == null ? 43 : ((Object)$edgeTypes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EdgeSearchQuery(parameters=" + String.valueOf(this.getParameters()) + ", relationType=" + this.getRelationType() + ", edgeTypes=" + String.valueOf(this.getEdgeTypes()) + ")";
    }
}

