/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.device.profile.lwm2m;

import lombok.Generated;

public enum TelemetryObserveStrategy {
    SINGLE("One resource equals one single observe request", 0),
    COMPOSITE_ALL("All resources in one composite observe request", 1),
    COMPOSITE_BY_OBJECT("Grouped composite observe requests by object", 2);

    private final String description;
    private final int id;

    private TelemetryObserveStrategy(String description, int id) {
        this.description = description;
        this.id = id;
    }

    public static TelemetryObserveStrategy fromDescription(String description) {
        for (TelemetryObserveStrategy strategy : TelemetryObserveStrategy.values()) {
            if (!strategy.description.equalsIgnoreCase(description)) continue;
            return strategy;
        }
        throw new IllegalArgumentException("Unknown TelemetryObserveStrategy id: " + description);
    }

    public static TelemetryObserveStrategy fromId(int id) {
        for (TelemetryObserveStrategy strategy : TelemetryObserveStrategy.values()) {
            if (strategy.id != id) continue;
            return strategy;
        }
        throw new IllegalArgumentException("Unknown TelemetryObserveStrategy id: " + id);
    }

    public String toString() {
        return this.name() + " (" + this.id + "): " + this.description;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public int getId() {
        return this.id;
    }
}

