/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.device.profile;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import lombok.Generated;
import org.thingsboard.server.common.data.device.profile.AlarmCondition;
import org.thingsboard.server.common.data.device.profile.AlarmSchedule;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class AlarmRule
implements Serializable {
    @Valid
    @Schema(description="JSON object representing the alarm rule condition")
    private AlarmCondition condition;
    @Schema(description="JSON object representing time interval during which the rule is active")
    private AlarmSchedule schedule;
    @NoXss
    @Schema(description="String value representing the additional details for an alarm rule")
    private String alarmDetails;
    @Schema(description="JSON object with the dashboard Id representing the reference to alarm details dashboard used by mobile application")
    private DashboardId dashboardId;

    @Generated
    public AlarmRule() {
    }

    @Generated
    public AlarmCondition getCondition() {
        return this.condition;
    }

    @Generated
    public AlarmSchedule getSchedule() {
        return this.schedule;
    }

    @Generated
    public String getAlarmDetails() {
        return this.alarmDetails;
    }

    @Generated
    public DashboardId getDashboardId() {
        return this.dashboardId;
    }

    @Generated
    public void setCondition(AlarmCondition condition) {
        this.condition = condition;
    }

    @Generated
    public void setSchedule(AlarmSchedule schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setAlarmDetails(String alarmDetails) {
        this.alarmDetails = alarmDetails;
    }

    @Generated
    public void setDashboardId(DashboardId dashboardId) {
        this.dashboardId = dashboardId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmRule)) {
            return false;
        }
        AlarmRule other = (AlarmRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AlarmCondition this$condition = this.getCondition();
        AlarmCondition other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition)) {
            return false;
        }
        AlarmSchedule this$schedule = this.getSchedule();
        AlarmSchedule other$schedule = other.getSchedule();
        if (this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule)) {
            return false;
        }
        String this$alarmDetails = this.getAlarmDetails();
        String other$alarmDetails = other.getAlarmDetails();
        if (this$alarmDetails == null ? other$alarmDetails != null : !this$alarmDetails.equals(other$alarmDetails)) {
            return false;
        }
        DashboardId this$dashboardId = this.getDashboardId();
        DashboardId other$dashboardId = other.getDashboardId();
        return !(this$dashboardId == null ? other$dashboardId != null : !((Object)this$dashboardId).equals(other$dashboardId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlarmRule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AlarmCondition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
        AlarmSchedule $schedule = this.getSchedule();
        result = result * 59 + ($schedule == null ? 43 : $schedule.hashCode());
        String $alarmDetails = this.getAlarmDetails();
        result = result * 59 + ($alarmDetails == null ? 43 : $alarmDetails.hashCode());
        DashboardId $dashboardId = this.getDashboardId();
        result = result * 59 + ($dashboardId == null ? 43 : ((Object)$dashboardId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AlarmRule(condition=" + String.valueOf(this.getCondition()) + ", schedule=" + String.valueOf(this.getSchedule()) + ", alarmDetails=" + this.getAlarmDetails() + ", dashboardId=" + String.valueOf(this.getDashboardId()) + ")";
    }
}

