/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.device;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.RelationEntityTypeFilter;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;

@Schema
public class DeviceSearchQuery {
    @Schema(description="Main search parameters.")
    private RelationsSearchParameters parameters;
    @Schema(description="Type of the relation between root entity and device (e.g. 'Contains' or 'Manages').")
    private String relationType;
    @Schema(description="Array of device types to filter the related entities (e.g. 'Temperature Sensor', 'Smoke Sensor').")
    private List<String> deviceTypes;

    public EntityRelationsQuery toEntitySearchQuery() {
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(this.parameters);
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter(this.relationType == null ? "Contains" : this.relationType, Collections.singletonList(EntityType.DEVICE))));
        return query;
    }

    @Generated
    public DeviceSearchQuery() {
    }

    @Generated
    public RelationsSearchParameters getParameters() {
        return this.parameters;
    }

    @Generated
    public String getRelationType() {
        return this.relationType;
    }

    @Generated
    public List<String> getDeviceTypes() {
        return this.deviceTypes;
    }

    @Generated
    public void setParameters(RelationsSearchParameters parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    @Generated
    public void setDeviceTypes(List<String> deviceTypes) {
        this.deviceTypes = deviceTypes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceSearchQuery)) {
            return false;
        }
        DeviceSearchQuery other = (DeviceSearchQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RelationsSearchParameters this$parameters = this.getParameters();
        RelationsSearchParameters other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$relationType = this.getRelationType();
        String other$relationType = other.getRelationType();
        if (this$relationType == null ? other$relationType != null : !this$relationType.equals(other$relationType)) {
            return false;
        }
        List<String> this$deviceTypes = this.getDeviceTypes();
        List<String> other$deviceTypes = other.getDeviceTypes();
        return !(this$deviceTypes == null ? other$deviceTypes != null : !((Object)this$deviceTypes).equals(other$deviceTypes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeviceSearchQuery;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelationsSearchParameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $relationType = this.getRelationType();
        result = result * 59 + ($relationType == null ? 43 : $relationType.hashCode());
        List<String> $deviceTypes = this.getDeviceTypes();
        result = result * 59 + ($deviceTypes == null ? 43 : ((Object)$deviceTypes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeviceSearchQuery(parameters=" + String.valueOf(this.getParameters()) + ", relationType=" + this.getRelationType() + ", deviceTypes=" + String.valueOf(this.getDeviceTypes()) + ")";
    }
}

