/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.converter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasDebugSettings;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.converter.ConverterType;
import org.thingsboard.server.common.data.debug.DebugSettings;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.IntegrationType;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
@JsonIgnoreProperties(ignoreUnknown=true)
public class Converter
extends BaseData<ConverterId>
implements HasName,
TenantEntity,
ExportableEntity<ConverterId>,
HasVersion,
HasDebugSettings {
    private static final long serialVersionUID = -1541581333235769915L;
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="name")
    private String name;
    private ConverterType type;
    private IntegrationType integrationType;
    @Deprecated
    private boolean debugMode;
    private DebugSettings debugSettings;
    private JsonNode configuration;
    @NoXss
    private JsonNode additionalInfo;
    private boolean edgeTemplate;
    private Integer converterVersion;
    private ConverterId externalId;
    private Long version;

    public Converter() {
    }

    public Converter(ConverterId id) {
        super(id);
    }

    public Converter(Converter converter) {
        super(converter);
        this.tenantId = converter.getTenantId();
        this.name = converter.getName();
        this.type = converter.getType();
        this.integrationType = converter.getIntegrationType();
        this.debugSettings = converter.getDebugSettings();
        this.configuration = converter.getConfiguration();
        this.additionalInfo = converter.getAdditionalInfo();
        this.edgeTemplate = converter.isEdgeTemplate();
        this.externalId = converter.getExternalId();
        this.version = converter.getVersion();
    }

    @Override
    @Schema(description="JSON object with the Converter Id. Specify this field to update the Converter. Referencing non-existing Converter Id will cause error. Omit this field to create new Converter.")
    public ConverterId getId() {
        return (ConverterId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the converter creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Schema(description="JSON object with Tenant Id", accessMode=Schema.AccessMode.READ_ONLY)
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Unique Converter Name in scope of Tenant", example="Http Converter")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The type of the converter to process incoming or outgoing messages")
    public ConverterType getType() {
        return this.type;
    }

    public void setType(ConverterType type) {
        this.type = type;
    }

    @Schema(description="The type of the integration to which the converter is dedicated")
    public IntegrationType getIntegrationType() {
        return this.integrationType;
    }

    @Override
    @Schema(description="Enable/disable debug. ", example="false", deprecated=true)
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    @Deprecated
    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    @Schema(description="Debug settings object.")
    public DebugSettings getDebugSettings() {
        return this.debugSettings;
    }

    @Override
    public void setDebugSettings(DebugSettings debugSettings) {
        this.debugSettings = debugSettings;
    }

    @Schema(description="JSON object representing converter configuration. It should contain one of two possible fields: 'decoder' or 'encoder'. The former is used when the converter has UPLINK type, the latter is used - when DOWNLINK type. It can contain both 'decoder' and 'encoder' fields, when the correct one is specified for the appropriate converter type, another one can be set to 'null'")
    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    @Schema(description="Additional parameters of the converter", implementation=JsonNode.class)
    public JsonNode getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(JsonNode additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @Schema(description="Boolean flag that specifies that is regular or edge template converter")
    public boolean isEdgeTemplate() {
        return this.edgeTemplate;
    }

    public void setEdgeTemplate(boolean edgeTemplate) {
        this.edgeTemplate = edgeTemplate;
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.CONVERTER;
    }

    @JsonIgnore
    public boolean isDedicated() {
        return this.integrationType != null && this.converterVersion != null && this.converterVersion == 2;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Converter)) {
            return false;
        }
        Converter other = (Converter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDebugMode() != other.isDebugMode()) {
            return false;
        }
        if (this.isEdgeTemplate() != other.isEdgeTemplate()) {
            return false;
        }
        Integer this$converterVersion = this.getConverterVersion();
        Integer other$converterVersion = other.getConverterVersion();
        if (this$converterVersion == null ? other$converterVersion != null : !((Object)this$converterVersion).equals(other$converterVersion)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ConverterType this$type = this.getType();
        ConverterType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        IntegrationType this$integrationType = this.getIntegrationType();
        IntegrationType other$integrationType = other.getIntegrationType();
        if (this$integrationType == null ? other$integrationType != null : !((Object)((Object)this$integrationType)).equals((Object)other$integrationType)) {
            return false;
        }
        DebugSettings this$debugSettings = this.getDebugSettings();
        DebugSettings other$debugSettings = other.getDebugSettings();
        if (this$debugSettings == null ? other$debugSettings != null : !((Object)this$debugSettings).equals(other$debugSettings)) {
            return false;
        }
        JsonNode this$configuration = this.getConfiguration();
        JsonNode other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        JsonNode this$additionalInfo = this.getAdditionalInfo();
        JsonNode other$additionalInfo = other.getAdditionalInfo();
        if (this$additionalInfo == null ? other$additionalInfo != null : !this$additionalInfo.equals(other$additionalInfo)) {
            return false;
        }
        ConverterId this$externalId = this.getExternalId();
        ConverterId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Converter;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDebugMode() ? 79 : 97);
        result = result * 59 + (this.isEdgeTemplate() ? 79 : 97);
        Integer $converterVersion = this.getConverterVersion();
        result = result * 59 + ($converterVersion == null ? 43 : ((Object)$converterVersion).hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ConverterType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        IntegrationType $integrationType = this.getIntegrationType();
        result = result * 59 + ($integrationType == null ? 43 : ((Object)((Object)$integrationType)).hashCode());
        DebugSettings $debugSettings = this.getDebugSettings();
        result = result * 59 + ($debugSettings == null ? 43 : ((Object)$debugSettings).hashCode());
        JsonNode $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        JsonNode $additionalInfo = this.getAdditionalInfo();
        result = result * 59 + ($additionalInfo == null ? 43 : $additionalInfo.hashCode());
        ConverterId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Converter(super=" + super.toString() + ", tenantId=" + String.valueOf(this.getTenantId()) + ", name=" + this.getName() + ", type=" + String.valueOf((Object)this.getType()) + ", integrationType=" + String.valueOf((Object)this.getIntegrationType()) + ", debugMode=" + this.isDebugMode() + ", debugSettings=" + String.valueOf(this.getDebugSettings()) + ", configuration=" + String.valueOf(this.getConfiguration()) + ", additionalInfo=" + String.valueOf(this.getAdditionalInfo()) + ", edgeTemplate=" + this.isEdgeTemplate() + ", converterVersion=" + this.getConverterVersion() + ", externalId=" + String.valueOf(this.getExternalId()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public void setIntegrationType(IntegrationType integrationType) {
        this.integrationType = integrationType;
    }

    @Generated
    public Integer getConverterVersion() {
        return this.converterVersion;
    }

    @Generated
    public void setConverterVersion(Integer converterVersion) {
        this.converterVersion = converterVersion;
    }

    @Override
    @Generated
    public ConverterId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public void setExternalId(ConverterId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }
}

