/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.cf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasDebugSettings;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.SimpleCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.debug.DebugSettings;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class CalculatedField
extends BaseData<CalculatedFieldId>
implements HasName,
TenantEntity,
HasVersion,
HasDebugSettings {
    private static final long serialVersionUID = 4491966747773381420L;
    private TenantId tenantId;
    private EntityId entityId;
    @NoXss
    @Length(fieldName="type")
    private CalculatedFieldType type;
    @NoXss
    @Length(fieldName="name")
    @Schema(description="User defined name of the calculated field.")
    private String name;
    @Deprecated
    @Schema(description="Enable/disable debug. ", example="false", deprecated=true)
    private boolean debugMode;
    @Schema(description="Debug settings object.")
    private DebugSettings debugSettings;
    @Schema(description="Version of calculated field configuration.", example="0")
    private int configurationVersion;
    @Schema(implementation=SimpleCalculatedFieldConfiguration.class)
    private CalculatedFieldConfiguration configuration;
    private Long version;

    public CalculatedField() {
    }

    public CalculatedField(CalculatedFieldId id) {
        super(id);
    }

    public CalculatedField(TenantId tenantId, EntityId entityId, CalculatedFieldType type, String name, int configurationVersion, CalculatedFieldConfiguration configuration, Long version) {
        this.tenantId = tenantId;
        this.entityId = entityId;
        this.type = type;
        this.name = name;
        this.configurationVersion = configurationVersion;
        this.configuration = configuration;
        this.version = version;
    }

    public CalculatedField(CalculatedField calculatedField) {
        super(calculatedField);
        this.tenantId = calculatedField.tenantId;
        this.entityId = calculatedField.entityId;
        this.type = calculatedField.type;
        this.name = calculatedField.name;
        this.debugMode = calculatedField.debugMode;
        this.debugSettings = calculatedField.debugSettings;
        this.configurationVersion = calculatedField.configurationVersion;
        this.configuration = calculatedField.configuration;
        this.version = calculatedField.version;
    }

    @Override
    @Schema(description="JSON object with the Calculated Field Id. Referencing non-existing Calculated Field Id will cause error.")
    public CalculatedFieldId getId() {
        return (CalculatedFieldId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the calculated field creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @JsonIgnore
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    @JsonSetter
    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.CALCULATED_FIELD;
    }

    @Override
    public String toString() {
        return "CalculatedField[" + "tenantId=" + this.tenantId + ", entityId=" + this.entityId + ", type='" + (Object)((Object)this.type) + ", name='" + this.name + ", configurationVersion=" + this.configurationVersion + ", configuration=" + this.configuration + ", version=" + this.version + ", createdTime=" + this.createdTime + ", id=" + this.id + ']';
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public CalculatedFieldType getType() {
        return this.type;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public DebugSettings getDebugSettings() {
        return this.debugSettings;
    }

    @Generated
    public int getConfigurationVersion() {
        return this.configurationVersion;
    }

    @Generated
    public CalculatedFieldConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setType(CalculatedFieldType type) {
        this.type = type;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Generated
    public void setDebugSettings(DebugSettings debugSettings) {
        this.debugSettings = debugSettings;
    }

    @Generated
    public void setConfigurationVersion(int configurationVersion) {
        this.configurationVersion = configurationVersion;
    }

    @Generated
    public void setConfiguration(CalculatedFieldConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculatedField)) {
            return false;
        }
        CalculatedField other = (CalculatedField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDebugMode() != other.isDebugMode()) {
            return false;
        }
        if (this.getConfigurationVersion() != other.getConfigurationVersion()) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        CalculatedFieldType this$type = this.getType();
        CalculatedFieldType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DebugSettings this$debugSettings = this.getDebugSettings();
        DebugSettings other$debugSettings = other.getDebugSettings();
        if (this$debugSettings == null ? other$debugSettings != null : !((Object)this$debugSettings).equals(other$debugSettings)) {
            return false;
        }
        CalculatedFieldConfiguration this$configuration = this.getConfiguration();
        CalculatedFieldConfiguration other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculatedField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDebugMode() ? 79 : 97);
        result = result * 59 + this.getConfigurationVersion();
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        CalculatedFieldType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DebugSettings $debugSettings = this.getDebugSettings();
        result = result * 59 + ($debugSettings == null ? 43 : ((Object)$debugSettings).hashCode());
        CalculatedFieldConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }
}

