/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.blob;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.BlobEntityId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;

public class BlobEntityInfo
extends BaseDataWithAdditionalInfo<BlobEntityId>
implements HasName,
TenantEntity,
HasCustomerId,
HasOwnerId {
    private static final long serialVersionUID = 2807223040519549363L;
    @Schema(description="JSON object with Tenant Id", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @Schema(description="JSON object with Customer Id", accessMode=Schema.AccessMode.READ_ONLY)
    private CustomerId customerId;
    @Length(fieldName="name")
    @Schema(description="blob entity name", accessMode=Schema.AccessMode.READ_ONLY, example="report-2021-10-29_14:00:00.pdf")
    private String name;
    @Length(fieldName="type")
    @Schema(description="blob entity type", accessMode=Schema.AccessMode.READ_ONLY, example="report")
    private String type;
    @Length(fieldName="contentType")
    @Schema(description="blob content type", accessMode=Schema.AccessMode.READ_ONLY, example="application/pdf", allowableValues={"application/pdf", "image/jpeg", "image/png"})
    private String contentType;

    public BlobEntityInfo() {
    }

    public BlobEntityInfo(BlobEntityId id) {
        super(id);
    }

    public BlobEntityInfo(BlobEntityInfo blobEntityInfo) {
        super(blobEntityInfo);
        this.tenantId = blobEntityInfo.getTenantId();
        this.customerId = blobEntityInfo.getCustomerId();
        this.name = blobEntityInfo.getName();
        this.type = blobEntityInfo.getType();
        this.contentType = blobEntityInfo.getContentType();
    }

    @Override
    @Schema(description="JSON object with the blob entity Id. Referencing non-existing blob entity Id will cause error")
    public BlobEntityId getId() {
        return (BlobEntityId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the blob entity creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Schema(description="Additional parameters of the blob entity", implementation=JsonNode.class)
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.BLOB_ENTITY;
    }

    @Override
    @Schema(description="JSON object with Customer or Tenant Id", accessMode=Schema.AccessMode.READ_ONLY)
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    @Generated
    public String toString() {
        return "BlobEntityInfo(tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", name=" + this.getName() + ", type=" + this.getType() + ", contentType=" + this.getContentType() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlobEntityInfo)) {
            return false;
        }
        BlobEntityInfo other = (BlobEntityInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BlobEntityInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        return result;
    }
}

