/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.audit;

import java.util.Optional;
import lombok.Generated;
import org.thingsboard.server.common.data.msg.TbMsgType;

public enum ActionType {
    ADDED(TbMsgType.ENTITY_CREATED),
    DELETED(TbMsgType.ENTITY_DELETED),
    UPDATED(TbMsgType.ENTITY_UPDATED),
    ATTRIBUTES_UPDATED(TbMsgType.ATTRIBUTES_UPDATED),
    ATTRIBUTES_DELETED(TbMsgType.ATTRIBUTES_DELETED),
    TIMESERIES_UPDATED(TbMsgType.TIMESERIES_UPDATED),
    TIMESERIES_DELETED(TbMsgType.TIMESERIES_DELETED),
    RPC_CALL,
    CREDENTIALS_UPDATED,
    ASSIGNED_TO_CUSTOMER(TbMsgType.ENTITY_ASSIGNED),
    UNASSIGNED_FROM_CUSTOMER(TbMsgType.ENTITY_UNASSIGNED),
    CHANGE_OWNER(TbMsgType.OWNER_CHANGED),
    ACTIVATED,
    SUSPENDED,
    CREDENTIALS_READ(true),
    ATTRIBUTES_READ(true),
    RELATION_ADD_OR_UPDATE(TbMsgType.RELATION_ADD_OR_UPDATE),
    RELATION_DELETED(TbMsgType.RELATION_DELETED),
    RELATIONS_DELETED(TbMsgType.RELATIONS_DELETED),
    ALARM_ACK(TbMsgType.ALARM_ACK, true),
    ALARM_CLEAR(TbMsgType.ALARM_CLEAR, true),
    ALARM_DELETE(TbMsgType.ALARM_DELETE, true),
    ALARM_ASSIGNED(TbMsgType.ALARM_ASSIGNED, true),
    ALARM_UNASSIGNED(TbMsgType.ALARM_UNASSIGNED, true),
    ADDED_TO_ENTITY_GROUP(TbMsgType.ADDED_TO_ENTITY_GROUP),
    REMOVED_FROM_ENTITY_GROUP(TbMsgType.REMOVED_FROM_ENTITY_GROUP),
    REST_API_RULE_ENGINE_CALL,
    MADE_PUBLIC,
    MADE_PRIVATE,
    LOGIN,
    LOGOUT,
    LOCKOUT,
    ASSIGNED_FROM_TENANT(TbMsgType.ENTITY_ASSIGNED_FROM_TENANT),
    ASSIGNED_TO_TENANT(TbMsgType.ENTITY_ASSIGNED_TO_TENANT),
    PROVISION_SUCCESS(TbMsgType.PROVISION_SUCCESS),
    PROVISION_FAILURE(TbMsgType.PROVISION_FAILURE),
    ASSIGNED_TO_EDGE(TbMsgType.ENTITY_ASSIGNED_TO_EDGE),
    UNASSIGNED_FROM_EDGE(TbMsgType.ENTITY_UNASSIGNED_FROM_EDGE),
    ADDED_COMMENT(TbMsgType.COMMENT_CREATED),
    UPDATED_COMMENT(TbMsgType.COMMENT_UPDATED),
    DELETED_COMMENT,
    SMS_SENT;

    private final boolean read;
    private final TbMsgType ruleEngineMsgType;
    private final boolean alarmAction;

    private ActionType() {
        this(false, null, false);
    }

    private ActionType(boolean read) {
        this(read, null, false);
    }

    private ActionType(TbMsgType ruleEngineMsgType) {
        this(false, ruleEngineMsgType, false);
    }

    private ActionType(TbMsgType ruleEngineMsgType, boolean isAlarmAction) {
        this(false, ruleEngineMsgType, isAlarmAction);
    }

    private ActionType(boolean read, TbMsgType ruleEngineMsgType, boolean alarmAction) {
        this.read = read;
        this.ruleEngineMsgType = ruleEngineMsgType;
        this.alarmAction = alarmAction;
    }

    public Optional<TbMsgType> getRuleEngineMsgType() {
        return Optional.ofNullable(this.ruleEngineMsgType);
    }

    @Generated
    public boolean isRead() {
        return this.read;
    }

    @Generated
    public boolean isAlarmAction() {
        return this.alarmAction;
    }
}

