/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.asset;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;

public final class AssetProfileInfo
extends EntityInfo {
    @Schema(description="Either URL or Base64 data of the icon. Used in the mobile application to visualize set of asset profiles in the grid view. ")
    private final String image;
    @Schema(description="Reference to the dashboard. Used in the mobile application to open the default dashboard when user navigates to asset details.")
    private final DashboardId defaultDashboardId;
    @Schema(description="Tenant id.")
    private final TenantId tenantId;

    @JsonCreator
    public AssetProfileInfo(@JsonProperty(value="id") EntityId id, @JsonProperty(value="tenantId") TenantId tenantId, @JsonProperty(value="name") String name, @JsonProperty(value="image") String image, @JsonProperty(value="defaultDashboardId") DashboardId defaultDashboardId) {
        super(id, name);
        this.tenantId = tenantId;
        this.image = image;
        this.defaultDashboardId = defaultDashboardId;
    }

    public AssetProfileInfo(UUID uuid, UUID tenantId, String name, String image, UUID defaultDashboardId) {
        super(EntityIdFactory.getByTypeAndUuid(EntityType.ASSET_PROFILE, uuid), name);
        this.tenantId = TenantId.fromUUID(tenantId);
        this.image = image;
        this.defaultDashboardId = defaultDashboardId != null ? new DashboardId(defaultDashboardId) : null;
    }

    public AssetProfileInfo(AssetProfile profile) {
        this(profile.getId(), profile.getTenantId(), profile.getName(), profile.getImage(), profile.getDefaultDashboardId());
    }

    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public DashboardId getDefaultDashboardId() {
        return this.defaultDashboardId;
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetProfileInfo)) {
            return false;
        }
        AssetProfileInfo other = (AssetProfileInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        DashboardId this$defaultDashboardId = this.getDefaultDashboardId();
        DashboardId other$defaultDashboardId = other.getDefaultDashboardId();
        if (this$defaultDashboardId == null ? other$defaultDashboardId != null : !((Object)this$defaultDashboardId).equals(other$defaultDashboardId)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetProfileInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        DashboardId $defaultDashboardId = this.getDefaultDashboardId();
        result = result * 59 + ($defaultDashboardId == null ? 43 : ((Object)$defaultDashboardId).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AssetProfileInfo(super=" + super.toString() + ", defaultDashboardId=" + String.valueOf(this.getDefaultDashboardId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ")";
    }
}

