/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmAssignee;

@Schema
public class AlarmInfo
extends Alarm {
    private static final long serialVersionUID = 2807343093519543363L;
    @Schema(description="Alarm originator name", example="Thermostat")
    private String originatorName;
    @Schema(description="Alarm originator label", example="Thermostat label")
    private String originatorLabel;
    @Schema(description="Alarm assignee")
    private AlarmAssignee assignee;

    public AlarmInfo() {
    }

    public AlarmInfo(Alarm alarm) {
        super(alarm);
    }

    public AlarmInfo(AlarmInfo alarmInfo) {
        super(alarmInfo);
        this.originatorName = alarmInfo.originatorName;
        this.originatorLabel = alarmInfo.originatorLabel;
        this.assignee = alarmInfo.getAssignee();
    }

    public AlarmInfo(Alarm alarm, String originatorName, String originatorLabel, AlarmAssignee assignee) {
        super(alarm);
        this.originatorName = originatorName;
        this.originatorLabel = originatorLabel;
        this.assignee = assignee;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmInfo)) {
            return false;
        }
        AlarmInfo other = (AlarmInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$originatorName = this.getOriginatorName();
        String other$originatorName = other.getOriginatorName();
        if (this$originatorName == null ? other$originatorName != null : !this$originatorName.equals(other$originatorName)) {
            return false;
        }
        String this$originatorLabel = this.getOriginatorLabel();
        String other$originatorLabel = other.getOriginatorLabel();
        if (this$originatorLabel == null ? other$originatorLabel != null : !this$originatorLabel.equals(other$originatorLabel)) {
            return false;
        }
        AlarmAssignee this$assignee = this.getAssignee();
        AlarmAssignee other$assignee = other.getAssignee();
        return !(this$assignee == null ? other$assignee != null : !((Object)this$assignee).equals(other$assignee));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlarmInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $originatorName = this.getOriginatorName();
        result = result * 59 + ($originatorName == null ? 43 : $originatorName.hashCode());
        String $originatorLabel = this.getOriginatorLabel();
        result = result * 59 + ($originatorLabel == null ? 43 : $originatorLabel.hashCode());
        AlarmAssignee $assignee = this.getAssignee();
        result = result * 59 + ($assignee == null ? 43 : ((Object)$assignee).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AlarmInfo(super=" + super.toString() + ", originatorName=" + this.getOriginatorName() + ", originatorLabel=" + this.getOriginatorLabel() + ", assignee=" + String.valueOf(this.getAssignee()) + ")";
    }

    @Generated
    public String getOriginatorName() {
        return this.originatorName;
    }

    @Generated
    public void setOriginatorName(String originatorName) {
        this.originatorName = originatorName;
    }

    @Generated
    public String getOriginatorLabel() {
        return this.originatorLabel;
    }

    @Generated
    public void setOriginatorLabel(String originatorLabel) {
        this.originatorLabel = originatorLabel;
    }

    @Generated
    public AlarmAssignee getAssignee() {
        return this.assignee;
    }

    @Generated
    public void setAssignee(AlarmAssignee assignee) {
        this.assignee = assignee;
    }
}

