/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.alarm.AlarmCommentType;
import org.thingsboard.server.common.data.id.AlarmCommentId;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class AlarmComment
extends BaseData<AlarmCommentId>
implements HasName {
    private static final long serialVersionUID = -5454905526404017592L;
    @Schema(description="JSON object with Alarm id.", accessMode=Schema.AccessMode.READ_ONLY)
    private AlarmId alarmId;
    @Schema(description="JSON object with User id.", accessMode=Schema.AccessMode.READ_ONLY)
    private UserId userId;
    @Schema(description="Defines origination of comment. System type means comment was created by TB. OTHER type means comment was created by user.", example="SYSTEM/OTHER", accessMode=Schema.AccessMode.READ_ONLY)
    private AlarmCommentType type;
    @Schema(description="JSON object with text of comment.")
    @NoXss
    @Length(fieldName="comment", max=10000)
    private JsonNode comment;

    @Override
    @Schema(description="JSON object with the alarm comment Id. Specify this field to update the alarm comment. Referencing non-existing alarm Id will cause error. Omit this field to create new alarm.", accessMode=Schema.AccessMode.READ_ONLY)
    public AlarmCommentId getId() {
        return (AlarmCommentId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the alarm comment creation, in milliseconds", example="1634058704567", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    public AlarmComment() {
    }

    public AlarmComment(AlarmCommentId id) {
        super(id);
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="representing comment text", example="Please take a look")
    public String getName() {
        return this.comment.toString();
    }

    public AlarmComment(AlarmComment alarmComment) {
        super(alarmComment.getId());
        this.createdTime = alarmComment.getCreatedTime();
        this.alarmId = alarmComment.getAlarmId();
        this.type = alarmComment.getType();
        this.comment = alarmComment.getComment();
        this.userId = alarmComment.getUserId();
    }

    @Generated
    public static AlarmCommentBuilder builder() {
        return new AlarmCommentBuilder();
    }

    @Generated
    public AlarmId getAlarmId() {
        return this.alarmId;
    }

    @Generated
    public UserId getUserId() {
        return this.userId;
    }

    @Generated
    public AlarmCommentType getType() {
        return this.type;
    }

    @Generated
    public JsonNode getComment() {
        return this.comment;
    }

    @Generated
    public void setAlarmId(AlarmId alarmId) {
        this.alarmId = alarmId;
    }

    @Generated
    public void setUserId(UserId userId) {
        this.userId = userId;
    }

    @Generated
    public void setType(AlarmCommentType type) {
        this.type = type;
    }

    @Generated
    public void setComment(JsonNode comment) {
        this.comment = comment;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmComment)) {
            return false;
        }
        AlarmComment other = (AlarmComment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AlarmId this$alarmId = this.getAlarmId();
        AlarmId other$alarmId = other.getAlarmId();
        if (this$alarmId == null ? other$alarmId != null : !((Object)this$alarmId).equals(other$alarmId)) {
            return false;
        }
        UserId this$userId = this.getUserId();
        UserId other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        AlarmCommentType this$type = this.getType();
        AlarmCommentType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        JsonNode this$comment = this.getComment();
        JsonNode other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlarmComment;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AlarmId $alarmId = this.getAlarmId();
        result = result * 59 + ($alarmId == null ? 43 : ((Object)$alarmId).hashCode());
        UserId $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        AlarmCommentType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        JsonNode $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AlarmComment(alarmId=" + String.valueOf(this.getAlarmId()) + ", userId=" + String.valueOf(this.getUserId()) + ", type=" + String.valueOf((Object)this.getType()) + ", comment=" + String.valueOf(this.getComment()) + ")";
    }

    @ConstructorProperties(value={"alarmId", "userId", "type", "comment"})
    @Generated
    public AlarmComment(AlarmId alarmId, UserId userId, AlarmCommentType type, JsonNode comment) {
        this.alarmId = alarmId;
        this.userId = userId;
        this.type = type;
        this.comment = comment;
    }

    @Generated
    public static class AlarmCommentBuilder {
        @Generated
        private AlarmId alarmId;
        @Generated
        private UserId userId;
        @Generated
        private AlarmCommentType type;
        @Generated
        private JsonNode comment;

        @Generated
        AlarmCommentBuilder() {
        }

        @Generated
        public AlarmCommentBuilder alarmId(AlarmId alarmId) {
            this.alarmId = alarmId;
            return this;
        }

        @Generated
        public AlarmCommentBuilder userId(UserId userId) {
            this.userId = userId;
            return this;
        }

        @Generated
        public AlarmCommentBuilder type(AlarmCommentType type) {
            this.type = type;
            return this;
        }

        @Generated
        public AlarmCommentBuilder comment(JsonNode comment) {
            this.comment = comment;
            return this;
        }

        @Generated
        public AlarmComment build() {
            return new AlarmComment(this.alarmId, this.userId, this.type, this.comment);
        }

        @Generated
        public String toString() {
            return "AlarmComment.AlarmCommentBuilder(alarmId=" + String.valueOf(this.alarmId) + ", userId=" + String.valueOf(this.userId) + ", type=" + String.valueOf((Object)this.type) + ", comment=" + String.valueOf(this.comment) + ")";
        }
    }
}

