/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.ai.model.chat;

import dev.langchain4j.model.chat.ChatModel;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import lombok.Generated;
import org.thingsboard.server.common.data.ai.model.chat.AiChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.Langchain4jChatModelConfigurer;
import org.thingsboard.server.common.data.ai.provider.AiProvider;
import org.thingsboard.server.common.data.ai.provider.OpenAiProviderConfig;

public final class OpenAiChatModelConfig
extends Record
implements AiChatModelConfig<OpenAiChatModelConfig> {
    @NotNull
    @Valid
    private final OpenAiProviderConfig providerConfig;
    @NotBlank
    private final String modelId;
    @PositiveOrZero
    private final Double temperature;
    @Positive
    @Max(value=1L)
    private final @Positive @Max(value=1L) Double topP;
    private final Double frequencyPenalty;
    private final Double presencePenalty;
    private final Integer maxOutputTokens;
    @Positive
    private final Integer timeoutSeconds;
    @PositiveOrZero
    private final Integer maxRetries;

    public OpenAiChatModelConfig(@NotNull @Valid OpenAiProviderConfig providerConfig, @NotBlank String modelId, @PositiveOrZero Double temperature, @Positive @Max(value=1L) @Positive @Max(value=1L) Double topP, Double frequencyPenalty, Double presencePenalty, Integer maxOutputTokens, @Positive Integer timeoutSeconds, @PositiveOrZero Integer maxRetries) {
        this.providerConfig = providerConfig;
        this.modelId = modelId;
        this.temperature = temperature;
        this.topP = topP;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.maxOutputTokens = maxOutputTokens;
        this.timeoutSeconds = timeoutSeconds;
        this.maxRetries = maxRetries;
    }

    @Override
    public AiProvider provider() {
        return AiProvider.OPENAI;
    }

    @Override
    public ChatModel configure(Langchain4jChatModelConfigurer configurer) {
        return configurer.configureChatModel(this);
    }

    @Override
    public boolean supportsJsonMode() {
        return true;
    }

    @Generated
    public static OpenAiChatModelConfigBuilder builder() {
        return new OpenAiChatModelConfigBuilder();
    }

    @Override
    @Generated
    public OpenAiChatModelConfig withTimeoutSeconds(Integer timeoutSeconds) {
        return this.timeoutSeconds == timeoutSeconds ? this : new OpenAiChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.frequencyPenalty, this.presencePenalty, this.maxOutputTokens, timeoutSeconds, this.maxRetries);
    }

    @Override
    @Generated
    public OpenAiChatModelConfig withMaxRetries(Integer maxRetries) {
        return this.maxRetries == maxRetries ? this : new OpenAiChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.frequencyPenalty, this.presencePenalty, this.maxOutputTokens, this.timeoutSeconds, maxRetries);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{OpenAiChatModelConfig.class, "providerConfig;modelId;temperature;topP;frequencyPenalty;presencePenalty;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "frequencyPenalty", "presencePenalty", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OpenAiChatModelConfig.class, "providerConfig;modelId;temperature;topP;frequencyPenalty;presencePenalty;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "frequencyPenalty", "presencePenalty", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OpenAiChatModelConfig.class, "providerConfig;modelId;temperature;topP;frequencyPenalty;presencePenalty;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "frequencyPenalty", "presencePenalty", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this, o);
    }

    @Override
    @NotNull
    @Valid
    public OpenAiProviderConfig providerConfig() {
        return this.providerConfig;
    }

    @NotBlank
    public String modelId() {
        return this.modelId;
    }

    @PositiveOrZero
    public Double temperature() {
        return this.temperature;
    }

    @Positive
    @Max(value=1L)
    public @Positive @Max(value=1L) Double topP() {
        return this.topP;
    }

    public Double frequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Double presencePenalty() {
        return this.presencePenalty;
    }

    public Integer maxOutputTokens() {
        return this.maxOutputTokens;
    }

    @Override
    @Positive
    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    @PositiveOrZero
    public Integer maxRetries() {
        return this.maxRetries;
    }

    @Generated
    public static class OpenAiChatModelConfigBuilder {
        @Generated
        private OpenAiProviderConfig providerConfig;
        @Generated
        private String modelId;
        @Generated
        private Double temperature;
        @Generated
        private Double topP;
        @Generated
        private Double frequencyPenalty;
        @Generated
        private Double presencePenalty;
        @Generated
        private Integer maxOutputTokens;
        @Generated
        private Integer timeoutSeconds;
        @Generated
        private Integer maxRetries;

        @Generated
        OpenAiChatModelConfigBuilder() {
        }

        @Generated
        public OpenAiChatModelConfigBuilder providerConfig(OpenAiProviderConfig providerConfig) {
            this.providerConfig = providerConfig;
            return this;
        }

        @Generated
        public OpenAiChatModelConfigBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public OpenAiChatModelConfigBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public OpenAiChatModelConfigBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public OpenAiChatModelConfigBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @Generated
        public OpenAiChatModelConfigBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @Generated
        public OpenAiChatModelConfigBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        @Generated
        public OpenAiChatModelConfigBuilder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        @Generated
        public OpenAiChatModelConfigBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public OpenAiChatModelConfig build() {
            return new OpenAiChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.frequencyPenalty, this.presencePenalty, this.maxOutputTokens, this.timeoutSeconds, this.maxRetries);
        }

        @Generated
        public String toString() {
            return "OpenAiChatModelConfig.OpenAiChatModelConfigBuilder(providerConfig=" + String.valueOf(this.providerConfig) + ", modelId=" + this.modelId + ", temperature=" + this.temperature + ", topP=" + this.topP + ", frequencyPenalty=" + this.frequencyPenalty + ", presencePenalty=" + this.presencePenalty + ", maxOutputTokens=" + this.maxOutputTokens + ", timeoutSeconds=" + this.timeoutSeconds + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

