/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.ai.model.chat;

import dev.langchain4j.model.chat.ChatModel;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import lombok.Generated;
import org.thingsboard.server.common.data.ai.model.chat.AiChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.Langchain4jChatModelConfigurer;
import org.thingsboard.server.common.data.ai.provider.AiProvider;
import org.thingsboard.server.common.data.ai.provider.OllamaProviderConfig;

public final class OllamaChatModelConfig
extends Record
implements AiChatModelConfig<OllamaChatModelConfig> {
    @NotNull
    @Valid
    private final OllamaProviderConfig providerConfig;
    @NotBlank
    private final String modelId;
    @PositiveOrZero
    private final Double temperature;
    @Positive
    @Max(value=1L)
    private final @Positive @Max(value=1L) Double topP;
    @PositiveOrZero
    private final Integer topK;
    private final Integer contextLength;
    private final Integer maxOutputTokens;
    @Positive
    private final Integer timeoutSeconds;
    @PositiveOrZero
    private final Integer maxRetries;

    public OllamaChatModelConfig(@NotNull @Valid OllamaProviderConfig providerConfig, @NotBlank String modelId, @PositiveOrZero Double temperature, @Positive @Max(value=1L) @Positive @Max(value=1L) Double topP, @PositiveOrZero Integer topK, Integer contextLength, Integer maxOutputTokens, @Positive Integer timeoutSeconds, @PositiveOrZero Integer maxRetries) {
        this.providerConfig = providerConfig;
        this.modelId = modelId;
        this.temperature = temperature;
        this.topP = topP;
        this.topK = topK;
        this.contextLength = contextLength;
        this.maxOutputTokens = maxOutputTokens;
        this.timeoutSeconds = timeoutSeconds;
        this.maxRetries = maxRetries;
    }

    @Override
    public AiProvider provider() {
        return AiProvider.OLLAMA;
    }

    @Override
    public ChatModel configure(Langchain4jChatModelConfigurer configurer) {
        return configurer.configureChatModel(this);
    }

    @Override
    public boolean supportsJsonMode() {
        return true;
    }

    @Generated
    public static OllamaChatModelConfigBuilder builder() {
        return new OllamaChatModelConfigBuilder();
    }

    @Override
    @Generated
    public OllamaChatModelConfig withTimeoutSeconds(Integer timeoutSeconds) {
        return this.timeoutSeconds == timeoutSeconds ? this : new OllamaChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.topK, this.contextLength, this.maxOutputTokens, timeoutSeconds, this.maxRetries);
    }

    @Override
    @Generated
    public OllamaChatModelConfig withMaxRetries(Integer maxRetries) {
        return this.maxRetries == maxRetries ? this : new OllamaChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.topK, this.contextLength, this.maxOutputTokens, this.timeoutSeconds, maxRetries);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{OllamaChatModelConfig.class, "providerConfig;modelId;temperature;topP;topK;contextLength;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "topK", "contextLength", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OllamaChatModelConfig.class, "providerConfig;modelId;temperature;topP;topK;contextLength;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "topK", "contextLength", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OllamaChatModelConfig.class, "providerConfig;modelId;temperature;topP;topK;contextLength;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "topK", "contextLength", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this, o);
    }

    @Override
    @NotNull
    @Valid
    public OllamaProviderConfig providerConfig() {
        return this.providerConfig;
    }

    @NotBlank
    public String modelId() {
        return this.modelId;
    }

    @PositiveOrZero
    public Double temperature() {
        return this.temperature;
    }

    @Positive
    @Max(value=1L)
    public @Positive @Max(value=1L) Double topP() {
        return this.topP;
    }

    @PositiveOrZero
    public Integer topK() {
        return this.topK;
    }

    public Integer contextLength() {
        return this.contextLength;
    }

    public Integer maxOutputTokens() {
        return this.maxOutputTokens;
    }

    @Override
    @Positive
    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    @PositiveOrZero
    public Integer maxRetries() {
        return this.maxRetries;
    }

    @Generated
    public static class OllamaChatModelConfigBuilder {
        @Generated
        private OllamaProviderConfig providerConfig;
        @Generated
        private String modelId;
        @Generated
        private Double temperature;
        @Generated
        private Double topP;
        @Generated
        private Integer topK;
        @Generated
        private Integer contextLength;
        @Generated
        private Integer maxOutputTokens;
        @Generated
        private Integer timeoutSeconds;
        @Generated
        private Integer maxRetries;

        @Generated
        OllamaChatModelConfigBuilder() {
        }

        @Generated
        public OllamaChatModelConfigBuilder providerConfig(OllamaProviderConfig providerConfig) {
            this.providerConfig = providerConfig;
            return this;
        }

        @Generated
        public OllamaChatModelConfigBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public OllamaChatModelConfigBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public OllamaChatModelConfigBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public OllamaChatModelConfigBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        @Generated
        public OllamaChatModelConfigBuilder contextLength(Integer contextLength) {
            this.contextLength = contextLength;
            return this;
        }

        @Generated
        public OllamaChatModelConfigBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        @Generated
        public OllamaChatModelConfigBuilder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        @Generated
        public OllamaChatModelConfigBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public OllamaChatModelConfig build() {
            return new OllamaChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.topK, this.contextLength, this.maxOutputTokens, this.timeoutSeconds, this.maxRetries);
        }

        @Generated
        public String toString() {
            return "OllamaChatModelConfig.OllamaChatModelConfigBuilder(providerConfig=" + String.valueOf(this.providerConfig) + ", modelId=" + this.modelId + ", temperature=" + this.temperature + ", topP=" + this.topP + ", topK=" + this.topK + ", contextLength=" + this.contextLength + ", maxOutputTokens=" + this.maxOutputTokens + ", timeoutSeconds=" + this.timeoutSeconds + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

