/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.ai.model.chat;

import dev.langchain4j.model.chat.ChatModel;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import lombok.Generated;
import org.thingsboard.server.common.data.ai.model.chat.AiChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.Langchain4jChatModelConfigurer;
import org.thingsboard.server.common.data.ai.provider.AiProvider;
import org.thingsboard.server.common.data.ai.provider.GoogleAiGeminiProviderConfig;

public final class GoogleAiGeminiChatModelConfig
extends Record
implements AiChatModelConfig<GoogleAiGeminiChatModelConfig> {
    @NotNull
    @Valid
    private final GoogleAiGeminiProviderConfig providerConfig;
    @NotBlank
    private final String modelId;
    @PositiveOrZero
    private final Double temperature;
    @Positive
    @Max(value=1L)
    private final @Positive @Max(value=1L) Double topP;
    @PositiveOrZero
    private final Integer topK;
    private final Double frequencyPenalty;
    private final Double presencePenalty;
    private final Integer maxOutputTokens;
    @Positive
    private final Integer timeoutSeconds;
    @PositiveOrZero
    private final Integer maxRetries;

    public GoogleAiGeminiChatModelConfig(@NotNull @Valid GoogleAiGeminiProviderConfig providerConfig, @NotBlank String modelId, @PositiveOrZero Double temperature, @Positive @Max(value=1L) @Positive @Max(value=1L) Double topP, @PositiveOrZero Integer topK, Double frequencyPenalty, Double presencePenalty, Integer maxOutputTokens, @Positive Integer timeoutSeconds, @PositiveOrZero Integer maxRetries) {
        this.providerConfig = providerConfig;
        this.modelId = modelId;
        this.temperature = temperature;
        this.topP = topP;
        this.topK = topK;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.maxOutputTokens = maxOutputTokens;
        this.timeoutSeconds = timeoutSeconds;
        this.maxRetries = maxRetries;
    }

    @Override
    public AiProvider provider() {
        return AiProvider.GOOGLE_AI_GEMINI;
    }

    @Override
    public ChatModel configure(Langchain4jChatModelConfigurer configurer) {
        return configurer.configureChatModel(this);
    }

    @Override
    public boolean supportsJsonMode() {
        return true;
    }

    @Generated
    public static GoogleAiGeminiChatModelConfigBuilder builder() {
        return new GoogleAiGeminiChatModelConfigBuilder();
    }

    @Override
    @Generated
    public GoogleAiGeminiChatModelConfig withTimeoutSeconds(Integer timeoutSeconds) {
        return this.timeoutSeconds == timeoutSeconds ? this : new GoogleAiGeminiChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.topK, this.frequencyPenalty, this.presencePenalty, this.maxOutputTokens, timeoutSeconds, this.maxRetries);
    }

    @Override
    @Generated
    public GoogleAiGeminiChatModelConfig withMaxRetries(Integer maxRetries) {
        return this.maxRetries == maxRetries ? this : new GoogleAiGeminiChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.topK, this.frequencyPenalty, this.presencePenalty, this.maxOutputTokens, this.timeoutSeconds, maxRetries);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{GoogleAiGeminiChatModelConfig.class, "providerConfig;modelId;temperature;topP;topK;frequencyPenalty;presencePenalty;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "topK", "frequencyPenalty", "presencePenalty", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GoogleAiGeminiChatModelConfig.class, "providerConfig;modelId;temperature;topP;topK;frequencyPenalty;presencePenalty;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "topK", "frequencyPenalty", "presencePenalty", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GoogleAiGeminiChatModelConfig.class, "providerConfig;modelId;temperature;topP;topK;frequencyPenalty;presencePenalty;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "topK", "frequencyPenalty", "presencePenalty", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this, o);
    }

    @Override
    @NotNull
    @Valid
    public GoogleAiGeminiProviderConfig providerConfig() {
        return this.providerConfig;
    }

    @NotBlank
    public String modelId() {
        return this.modelId;
    }

    @PositiveOrZero
    public Double temperature() {
        return this.temperature;
    }

    @Positive
    @Max(value=1L)
    public @Positive @Max(value=1L) Double topP() {
        return this.topP;
    }

    @PositiveOrZero
    public Integer topK() {
        return this.topK;
    }

    public Double frequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Double presencePenalty() {
        return this.presencePenalty;
    }

    public Integer maxOutputTokens() {
        return this.maxOutputTokens;
    }

    @Override
    @Positive
    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    @PositiveOrZero
    public Integer maxRetries() {
        return this.maxRetries;
    }

    @Generated
    public static class GoogleAiGeminiChatModelConfigBuilder {
        @Generated
        private GoogleAiGeminiProviderConfig providerConfig;
        @Generated
        private String modelId;
        @Generated
        private Double temperature;
        @Generated
        private Double topP;
        @Generated
        private Integer topK;
        @Generated
        private Double frequencyPenalty;
        @Generated
        private Double presencePenalty;
        @Generated
        private Integer maxOutputTokens;
        @Generated
        private Integer timeoutSeconds;
        @Generated
        private Integer maxRetries;

        @Generated
        GoogleAiGeminiChatModelConfigBuilder() {
        }

        @Generated
        public GoogleAiGeminiChatModelConfigBuilder providerConfig(GoogleAiGeminiProviderConfig providerConfig) {
            this.providerConfig = providerConfig;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelConfigBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelConfigBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelConfigBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelConfigBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelConfigBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelConfigBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelConfigBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelConfigBuilder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelConfigBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelConfig build() {
            return new GoogleAiGeminiChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.topK, this.frequencyPenalty, this.presencePenalty, this.maxOutputTokens, this.timeoutSeconds, this.maxRetries);
        }

        @Generated
        public String toString() {
            return "GoogleAiGeminiChatModelConfig.GoogleAiGeminiChatModelConfigBuilder(providerConfig=" + String.valueOf(this.providerConfig) + ", modelId=" + this.modelId + ", temperature=" + this.temperature + ", topP=" + this.topP + ", topK=" + this.topK + ", frequencyPenalty=" + this.frequencyPenalty + ", presencePenalty=" + this.presencePenalty + ", maxOutputTokens=" + this.maxOutputTokens + ", timeoutSeconds=" + this.timeoutSeconds + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

