/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.ai.dto;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.TextContent;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="contentType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=TbTextContent.class, name="TEXT")})
public interface TbContent {
    public TbContentType contentType();

    public Content toLangChainContent();

    @Schema(description="Text-based content part of a user's prompt")
    public record TbTextContent(@NotBlank @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The text content", example="What is the weather like in Kyiv today?") String text) implements TbContent
    {
        @Override
        public TbContentType contentType() {
            return TbContentType.TEXT;
        }

        @Override
        public Content toLangChainContent() {
            return TextContent.from((String)this.text);
        }
    }

    public static enum TbContentType {
        TEXT;

    }
}

