/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.ai.dto;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="status", include=JsonTypeInfo.As.EXISTING_PROPERTY, visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Success.class, name="SUCCESS"), @JsonSubTypes.Type(value=Failure.class, name="FAILURE")})
public interface TbChatResponse {
    @Schema(description="Indicates whether the request was successful or not", example="SUCCESS")
    public String getStatus();

    public record Failure(@Schema(description="A string containing details about the failure") String errorDetails) implements TbChatResponse
    {
        @Override
        @Schema(example="FAILURE")
        public String getStatus() {
            return "FAILURE";
        }
    }

    public record Success(@Schema(description="The text content generated by the model") String generatedContent) implements TbChatResponse
    {
        @Override
        @Schema(example="SUCCESS")
        public String getStatus() {
            return "SUCCESS";
        }
    }
}

