/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.ai;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.ai.model.AiModelConfig;
import org.thingsboard.server.common.data.id.AiModelId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoNullChar;

public final class AiModel
extends BaseData<AiModelId>
implements TenantEntity,
HasVersion,
ExportableEntity<AiModelId> {
    private static final long serialVersionUID = 9017108678716011604L;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="JSON object representing the ID of the tenant associated with this AI model", example="e3c4b7d2-5678-4a9b-0c1d-2e3f4a5b6c7d")
    private TenantId tenantId;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="Version of the AI model record; increments automatically whenever the record is changed", example="7", defaultValue="1")
    private Long version;
    @NotBlank
    @NoNullChar
    @Length(min=1, max=255)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_WRITE, description="Display name for this AI model configuration; not the technical model identifier", example="Fast and cost-efficient model")
    private String name;
    @NotNull
    @Valid
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED, accessMode=Schema.AccessMode.READ_WRITE, description="Configuration of the AI model")
    private AiModelConfig configuration;
    private AiModelId externalId;

    public AiModel() {
    }

    public AiModel(AiModelId id) {
        super(id);
    }

    public AiModel(AiModel model) {
        super((AiModelId)model.getId());
        this.createdTime = model.getCreatedTime();
        this.tenantId = model.getTenantId();
        this.version = model.getVersion();
        this.name = model.getName();
        this.configuration = model.getConfiguration();
        this.externalId = model.getExternalId() == null ? null : new AiModelId(model.getExternalId().getId());
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.AI_MODEL;
    }

    @Generated
    public static AiModelBuilder builder() {
        return new AiModelBuilder();
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public AiModelConfig getConfiguration() {
        return this.configuration;
    }

    @Override
    @Generated
    public AiModelId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setConfiguration(AiModelConfig configuration) {
        this.configuration = configuration;
    }

    @Override
    @Generated
    public void setExternalId(AiModelId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public String toString() {
        return "AiModel(tenantId=" + String.valueOf(this.getTenantId()) + ", version=" + this.getVersion() + ", name=" + this.getName() + ", configuration=" + String.valueOf(this.getConfiguration()) + ", externalId=" + String.valueOf(this.getExternalId()) + ")";
    }

    @ConstructorProperties(value={"tenantId", "version", "name", "configuration", "externalId"})
    @Generated
    public AiModel(TenantId tenantId, Long version, String name, AiModelConfig configuration, AiModelId externalId) {
        this.tenantId = tenantId;
        this.version = version;
        this.name = name;
        this.configuration = configuration;
        this.externalId = externalId;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AiModel)) {
            return false;
        }
        AiModel other = (AiModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        AiModelConfig this$configuration = this.getConfiguration();
        AiModelConfig other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        AiModelId this$externalId = this.getExternalId();
        AiModelId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AiModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        AiModelConfig $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        AiModelId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }

    @Generated
    public static class AiModelBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private Long version;
        @Generated
        private String name;
        @Generated
        private AiModelConfig configuration;
        @Generated
        private AiModelId externalId;

        @Generated
        AiModelBuilder() {
        }

        @Generated
        public AiModelBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public AiModelBuilder version(Long version) {
            this.version = version;
            return this;
        }

        @Generated
        public AiModelBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public AiModelBuilder configuration(AiModelConfig configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public AiModelBuilder externalId(AiModelId externalId) {
            this.externalId = externalId;
            return this;
        }

        @Generated
        public AiModel build() {
            return new AiModel(this.tenantId, this.version, this.name, this.configuration, this.externalId);
        }

        @Generated
        public String toString() {
            return "AiModel.AiModelBuilder(tenantId=" + String.valueOf(this.tenantId) + ", version=" + this.version + ", name=" + this.name + ", configuration=" + String.valueOf(this.configuration) + ", externalId=" + String.valueOf(this.externalId) + ")";
        }
    }
}

