/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.id.CustomMenuId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.notification.targets.NotificationRecipient;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class User
extends BaseDataWithAdditionalInfo<UserId>
implements GroupEntity<UserId>,
NotificationRecipient,
HasVersion {
    private static final long serialVersionUID = 8250339805336035966L;
    private TenantId tenantId;
    private CustomerId customerId;
    private String email;
    private Authority authority;
    @NoXss
    @Length(fieldName="first name")
    private String firstName;
    @NoXss
    @Length(fieldName="last name")
    private String lastName;
    @NoXss
    private String phone;
    private CustomMenuId customMenuId;
    private Long version;

    public User() {
    }

    public User(UserId id) {
        super(id);
    }

    public User(User user) {
        super(user);
        this.tenantId = user.getTenantId();
        this.customerId = user.getCustomerId();
        this.email = user.getEmail();
        this.authority = user.getAuthority();
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.phone = user.getPhone();
        this.version = user.getVersion();
        this.customMenuId = user.getCustomMenuId();
    }

    @Override
    @Schema(description="JSON object with the User Id. Specify this field to update the device. Referencing non-existing User Id will cause error. Omit this field to create new customer.")
    public UserId getId() {
        return (UserId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the user creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Schema(description="JSON object with the Tenant Id.", accessMode=Schema.AccessMode.READ_ONLY)
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    @Schema(description="JSON object with the Customer Id.", accessMode=Schema.AccessMode.READ_ONLY)
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Override
    @Schema(description="JSON object with Customer or Tenant Id", accessMode=Schema.AccessMode.READ_ONLY)
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @Override
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Email of the user", example="user@example.com")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="Duplicates the email of the user, readonly", example="user@example.com")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.email;
    }

    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Authority", example="SYS_ADMIN, TENANT_ADMIN or CUSTOMER_USER")
    public Authority getAuthority() {
        return this.authority;
    }

    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    @Override
    @Schema(description="First name of the user", example="John")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    @Schema(description="Last name of the user", example="Doe")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Schema(description="Phone number of the user", example="38012345123")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Override
    @Schema(description="Additional parameters of the user", implementation=JsonNode.class)
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @Override
    @JsonIgnore
    public String getTitle() {
        return User.getTitle(this.email, this.firstName, this.lastName);
    }

    public static String getTitle(String email, String firstName, String lastName) {
        Object title = "";
        if (StringUtils.isNotEmpty((CharSequence)firstName)) {
            title = (String)title + firstName;
        }
        if (StringUtils.isNotEmpty((CharSequence)lastName)) {
            if (!((String)title).isEmpty()) {
                title = (String)title + " ";
            }
            title = (String)title + lastName;
        }
        if (((String)title).isEmpty()) {
            title = email;
        }
        return title;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("User [tenantId=");
        builder.append(this.tenantId);
        builder.append(", customerId=");
        builder.append(this.customerId);
        builder.append(", email=");
        builder.append(this.email);
        builder.append(", authority=");
        builder.append((Object)this.authority);
        builder.append(", firstName=");
        builder.append(this.firstName);
        builder.append(", lastName=");
        builder.append(this.lastName);
        builder.append(", additionalInfo=");
        builder.append(this.getAdditionalInfo());
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    @JsonIgnore
    public boolean isSystemAdmin() {
        return this.tenantId == null || EntityId.NULL_UUID.equals(this.tenantId.getId());
    }

    @JsonIgnore
    public boolean isTenantAdmin() {
        return !this.isSystemAdmin() && (this.customerId == null || EntityId.NULL_UUID.equals(this.customerId.getId()));
    }

    @JsonIgnore
    public boolean isCustomerUser() {
        return !this.isSystemAdmin() && !this.isTenantAdmin();
    }

    @JsonIgnore
    public String getLocale() {
        return this.getAdditionalInfoField("lang", JsonNode::asText, Locale.US.toString());
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.USER;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        Authority this$authority = this.getAuthority();
        Authority other$authority = other.getAuthority();
        if (this$authority == null ? other$authority != null : !((Object)((Object)this$authority)).equals((Object)other$authority)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        CustomMenuId this$customMenuId = this.getCustomMenuId();
        CustomMenuId other$customMenuId = other.getCustomMenuId();
        return !(this$customMenuId == null ? other$customMenuId != null : !((Object)this$customMenuId).equals(other$customMenuId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        Authority $authority = this.getAuthority();
        result = result * 59 + ($authority == null ? 43 : ((Object)((Object)$authority)).hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        CustomMenuId $customMenuId = this.getCustomMenuId();
        result = result * 59 + ($customMenuId == null ? 43 : ((Object)$customMenuId).hashCode());
        return result;
    }

    @Generated
    public CustomMenuId getCustomMenuId() {
        return this.customMenuId;
    }

    @Generated
    public void setCustomMenuId(CustomMenuId customMenuId) {
        this.customMenuId = customMenuId;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }
}

