/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileData;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class TenantProfile
extends BaseData<TenantProfileId>
implements HasName {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantProfile.class);
    private static final long serialVersionUID = 3021989561267192281L;
    public static final ObjectMapper mapper = new ObjectMapper();
    @NoXss
    @Length(fieldName="name")
    @Schema(description="Name of the tenant profile", example="High Priority Tenants")
    private String name;
    @NoXss
    @Schema(description="Description of the tenant profile", example="Any text")
    private String description;
    @Schema(description="Default Tenant profile to be used.", example="false")
    @JsonProperty(value="default")
    private boolean isDefault;
    @Schema(description="If enabled, will push all messages related to this tenant and processed by the rule engine into separate queue. Useful for complex microservices deployments, to isolate processing of the data for specific tenants", example="false")
    private boolean isolatedTbRuleEngine;
    @Valid
    @Schema(description="Complex JSON object that contains profile settings: queue configs, max devices, max assets, rate limits, etc.")
    private transient TenantProfileData profileData;
    @JsonIgnore
    private byte[] profileDataBytes;

    public TenantProfile() {
    }

    public TenantProfile(TenantProfileId tenantProfileId) {
        super(tenantProfileId);
    }

    public TenantProfile(TenantProfile tenantProfile) {
        super(tenantProfile);
        this.name = tenantProfile.getName();
        this.description = tenantProfile.getDescription();
        this.isDefault = tenantProfile.isDefault();
        this.isolatedTbRuleEngine = tenantProfile.isIsolatedTbRuleEngine();
        this.setProfileData(tenantProfile.getProfileData());
    }

    @Override
    @Schema(description="JSON object with the tenant profile Id. Specify this field to update the tenant profile. Referencing non-existing tenant profile Id will cause error. Omit this field to create new tenant profile.")
    public TenantProfileId getId() {
        return (TenantProfileId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the tenant profile creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TenantProfileData getProfileData() {
        if (this.profileData != null) {
            return this.profileData;
        }
        if (this.profileDataBytes != null) {
            try {
                this.profileData = (TenantProfileData)mapper.readValue((InputStream)new ByteArrayInputStream(this.profileDataBytes), TenantProfileData.class);
            }
            catch (IOException e) {
                log.warn("Can't deserialize tenant profile data: ", (Throwable)e);
                return this.createDefaultTenantProfileData();
            }
            return this.profileData;
        }
        return this.createDefaultTenantProfileData();
    }

    @JsonIgnore
    public Optional<DefaultTenantProfileConfiguration> getProfileConfiguration() {
        return Optional.ofNullable(this.getProfileData().getConfiguration()).filter(profileConfiguration -> profileConfiguration instanceof DefaultTenantProfileConfiguration).map(profileConfiguration -> (DefaultTenantProfileConfiguration)profileConfiguration);
    }

    @JsonIgnore
    public DefaultTenantProfileConfiguration getDefaultProfileConfiguration() {
        return this.getProfileConfiguration().orElse(null);
    }

    public TenantProfileData createDefaultTenantProfileData() {
        TenantProfileData tpd = new TenantProfileData();
        tpd.setConfiguration(new DefaultTenantProfileConfiguration());
        this.profileData = tpd;
        return tpd;
    }

    public void setProfileData(TenantProfileData data) {
        this.profileData = data;
        try {
            this.profileDataBytes = data != null ? mapper.writeValueAsBytes((Object)data) : null;
        }
        catch (JsonProcessingException e) {
            log.warn("Can't serialize tenant profile data: ", (Throwable)e);
        }
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isDefault() {
        return this.isDefault;
    }

    @Generated
    public boolean isIsolatedTbRuleEngine() {
        return this.isolatedTbRuleEngine;
    }

    @Generated
    public byte[] getProfileDataBytes() {
        return this.profileDataBytes;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="default")
    @Generated
    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Generated
    public void setIsolatedTbRuleEngine(boolean isolatedTbRuleEngine) {
        this.isolatedTbRuleEngine = isolatedTbRuleEngine;
    }

    @JsonIgnore
    @Generated
    public void setProfileDataBytes(byte[] profileDataBytes) {
        this.profileDataBytes = profileDataBytes;
    }

    @Override
    @Generated
    public String toString() {
        return "TenantProfile(name=" + this.getName() + ", description=" + this.getDescription() + ", isDefault=" + this.isDefault() + ", isolatedTbRuleEngine=" + this.isIsolatedTbRuleEngine() + ", profileData=" + String.valueOf(this.getProfileData()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantProfile)) {
            return false;
        }
        TenantProfile other = (TenantProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDefault() != other.isDefault()) {
            return false;
        }
        if (this.isIsolatedTbRuleEngine() != other.isIsolatedTbRuleEngine()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        return Arrays.equals(this.getProfileDataBytes(), other.getProfileDataBytes());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TenantProfile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDefault() ? 79 : 97);
        result = result * 59 + (this.isIsolatedTbRuleEngine() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + Arrays.hashCode(this.getProfileDataBytes());
        return result;
    }
}

