/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.ResourceSubType;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class TbResourceInfo
extends BaseData<TbResourceId>
implements HasName,
TenantEntity,
ExportableEntity<TbResourceId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbResourceInfo.class);
    private static final long serialVersionUID = 7282664529021651736L;
    @Schema(description="JSON object with Tenant Id. Tenant Id of the resource can't be changed.", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @Schema(description="JSON object with Customer Id. Customer Id of the resource can't be changed.", accessMode=Schema.AccessMode.READ_ONLY)
    private CustomerId customerId;
    @NoXss
    @Length(fieldName="title")
    @Schema(description="Resource title.", example="BinaryAppDataContainer id=19 v1.0")
    private String title;
    @Schema(description="Resource type.", example="LWM2M_MODEL", accessMode=Schema.AccessMode.READ_ONLY)
    private ResourceType resourceType;
    @Schema(description="Resource sub type.", example="IOT_SVG", accessMode=Schema.AccessMode.READ_ONLY)
    private ResourceSubType resourceSubType;
    @NoXss
    @Length(fieldName="resourceKey")
    @Schema(description="Resource key.", example="19_1.0", accessMode=Schema.AccessMode.READ_ONLY)
    private String resourceKey;
    private boolean isPublic;
    private String publicResourceKey;
    @Schema(description="Resource search text.", example="19_1.0:binaryappdatacontainer", accessMode=Schema.AccessMode.READ_ONLY)
    private String searchText;
    @Schema(description="Resource etag.", example="33a64df551425fcc55e4d42a148795d9f25f89d4", accessMode=Schema.AccessMode.READ_ONLY)
    private String etag;
    @NoXss
    @Length(fieldName="file name")
    @Schema(description="Resource file name.", example="19.xml", accessMode=Schema.AccessMode.READ_ONLY)
    private String fileName;
    private JsonNode descriptor;
    private TbResourceId externalId;

    public TbResourceInfo() {
    }

    public TbResourceInfo(TbResourceId id) {
        super(id);
    }

    public TbResourceInfo(TbResourceInfo resourceInfo) {
        super(resourceInfo);
        this.tenantId = resourceInfo.tenantId;
        this.customerId = resourceInfo.customerId;
        this.title = resourceInfo.title;
        this.resourceType = resourceInfo.resourceType;
        this.resourceSubType = resourceInfo.resourceSubType;
        this.resourceKey = resourceInfo.resourceKey;
        this.searchText = resourceInfo.searchText;
        this.isPublic = resourceInfo.isPublic;
        this.publicResourceKey = resourceInfo.publicResourceKey;
        this.etag = resourceInfo.etag;
        this.fileName = resourceInfo.fileName;
        this.descriptor = resourceInfo.descriptor != null ? resourceInfo.descriptor.deepCopy() : null;
        this.externalId = resourceInfo.externalId;
    }

    @Override
    @Schema(description="JSON object with the Resource Id. Specify this field to update the Resource. Referencing non-existing Resource Id will cause error. Omit this field to create new Resource.")
    public TbResourceId getId() {
        return (TbResourceId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the resource creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.title;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getLink() {
        String scope;
        String string = scope = this.tenantId != null && this.tenantId.isSysTenantId() ? "system" : "tenant";
        if (this.resourceType == ResourceType.IMAGE) {
            return "/api/images/" + scope + "/" + this.resourceKey;
        }
        return "/api/resource/" + this.resourceType.name().toLowerCase() + "/" + scope + "/" + this.resourceKey;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getPublicLink() {
        if (this.resourceType == ResourceType.IMAGE && this.isPublic) {
            return "/api/images/public/" + this.getPublicResourceKey();
        }
        return null;
    }

    @JsonIgnore
    public String getSearchText() {
        return this.title;
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.TB_RESOURCE;
    }

    public <T> T getDescriptor(Class<T> type) {
        return (T)(this.descriptor != null ? mapper.treeToValue((TreeNode)this.descriptor, type) : null);
    }

    public <T> void updateDescriptor(Class<T> type, UnaryOperator<T> updater) {
        Object descriptor = this.getDescriptor(type);
        descriptor = updater.apply(descriptor);
        this.setDescriptorValue(descriptor);
    }

    @JsonIgnore
    public void setDescriptorValue(Object value) {
        this.descriptor = value != null ? mapper.valueToTree(value) : null;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @Generated
    public ResourceSubType getResourceSubType() {
        return this.resourceSubType;
    }

    @Generated
    public String getResourceKey() {
        return this.resourceKey;
    }

    @Generated
    public boolean isPublic() {
        return this.isPublic;
    }

    @Generated
    public String getPublicResourceKey() {
        return this.publicResourceKey;
    }

    @Generated
    public String getEtag() {
        return this.etag;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public JsonNode getDescriptor() {
        return this.descriptor;
    }

    @Override
    @Generated
    public TbResourceId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    @Generated
    public void setResourceSubType(ResourceSubType resourceSubType) {
        this.resourceSubType = resourceSubType;
    }

    @Generated
    public void setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    @Generated
    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Generated
    public void setPublicResourceKey(String publicResourceKey) {
        this.publicResourceKey = publicResourceKey;
    }

    @Generated
    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    @Generated
    public void setEtag(String etag) {
        this.etag = etag;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setDescriptor(JsonNode descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    @Generated
    public void setExternalId(TbResourceId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public String toString() {
        return "TbResourceInfo(tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", title=" + this.getTitle() + ", resourceType=" + String.valueOf((Object)this.getResourceType()) + ", resourceSubType=" + String.valueOf((Object)this.getResourceSubType()) + ", resourceKey=" + this.getResourceKey() + ", isPublic=" + this.isPublic() + ", publicResourceKey=" + this.getPublicResourceKey() + ", searchText=" + this.getSearchText() + ", etag=" + this.getEtag() + ", fileName=" + this.getFileName() + ", descriptor=" + String.valueOf(this.getDescriptor()) + ", externalId=" + String.valueOf(this.getExternalId()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbResourceInfo)) {
            return false;
        }
        TbResourceInfo other = (TbResourceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isPublic() != other.isPublic()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        ResourceType this$resourceType = this.getResourceType();
        ResourceType other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !((Object)((Object)this$resourceType)).equals((Object)other$resourceType)) {
            return false;
        }
        ResourceSubType this$resourceSubType = this.getResourceSubType();
        ResourceSubType other$resourceSubType = other.getResourceSubType();
        if (this$resourceSubType == null ? other$resourceSubType != null : !((Object)((Object)this$resourceSubType)).equals((Object)other$resourceSubType)) {
            return false;
        }
        String this$resourceKey = this.getResourceKey();
        String other$resourceKey = other.getResourceKey();
        if (this$resourceKey == null ? other$resourceKey != null : !this$resourceKey.equals(other$resourceKey)) {
            return false;
        }
        String this$publicResourceKey = this.getPublicResourceKey();
        String other$publicResourceKey = other.getPublicResourceKey();
        if (this$publicResourceKey == null ? other$publicResourceKey != null : !this$publicResourceKey.equals(other$publicResourceKey)) {
            return false;
        }
        String this$searchText = this.getSearchText();
        String other$searchText = other.getSearchText();
        if (this$searchText == null ? other$searchText != null : !this$searchText.equals(other$searchText)) {
            return false;
        }
        String this$etag = this.getEtag();
        String other$etag = other.getEtag();
        if (this$etag == null ? other$etag != null : !this$etag.equals(other$etag)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        JsonNode this$descriptor = this.getDescriptor();
        JsonNode other$descriptor = other.getDescriptor();
        if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
            return false;
        }
        TbResourceId this$externalId = this.getExternalId();
        TbResourceId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TbResourceInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isPublic() ? 79 : 97);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        ResourceType $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : ((Object)((Object)$resourceType)).hashCode());
        ResourceSubType $resourceSubType = this.getResourceSubType();
        result = result * 59 + ($resourceSubType == null ? 43 : ((Object)((Object)$resourceSubType)).hashCode());
        String $resourceKey = this.getResourceKey();
        result = result * 59 + ($resourceKey == null ? 43 : $resourceKey.hashCode());
        String $publicResourceKey = this.getPublicResourceKey();
        result = result * 59 + ($publicResourceKey == null ? 43 : $publicResourceKey.hashCode());
        String $searchText = this.getSearchText();
        result = result * 59 + ($searchText == null ? 43 : $searchText.hashCode());
        String $etag = this.getEtag();
        result = result * 59 + ($etag == null ? 43 : $etag.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        JsonNode $descriptor = this.getDescriptor();
        result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
        TbResourceId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }
}

